/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service.handler.impl;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.AuthenticationResult;
import org.wso2.carbon.identity.auth.service.AuthenticationStatus;
import org.wso2.carbon.identity.auth.service.exception.AuthenticationFailException;
import org.wso2.carbon.identity.auth.service.handler.AuthenticationHandler;
import org.wso2.carbon.identity.auth.service.util.AuthConfigurationUtil;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;

public class ClientAuthenticationHandler
extends AuthenticationHandler {
    private static final Log log = LogFactory.getLog(ClientAuthenticationHandler.class);
    private final String CLIENT_AUTH_HEADER = "Client";
    private final String hashingFunction = "SHA-256";
    private final String SERVICE_PROVIDER_KEY = "serviceProvider";

    public void init(InitConfig initConfig) {
    }

    public String getName() {
        return "ClientAuthentication";
    }

    public int getPriority(MessageContext messageContext) {
        return this.getPriority(messageContext, 130);
    }

    public boolean canHandle(MessageContext messageContext) {
        return AuthConfigurationUtil.isAuthHeaderMatch(messageContext, "Client");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected AuthenticationResult doAuthenticate(MessageContext messageContext) throws AuthenticationFailException {
        String[] splitAuthorizationHeader;
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationStatus.FAILED);
        AuthenticationContext authenticationContext = (AuthenticationContext)messageContext;
        String authorizationHeader = authenticationContext.getAuthenticationRequest().getHeader("Authorization");
        String serviceProvider = authenticationContext.getAuthenticationRequest().getHeader("serviceProvider".toLowerCase());
        if (StringUtils.isNotEmpty((String)serviceProvider)) {
            MDC.put((String)"serviceProvider", (String)serviceProvider);
        }
        if ((splitAuthorizationHeader = authorizationHeader.split(" ")).length != 2) {
            String errorMessage = "Error occurred while trying to authenticate. The Authorization header values are not defined correctly.";
            log.error((Object)errorMessage);
            throw new AuthenticationFailException(errorMessage);
        }
        byte[] decodedAuthHeader = Base64.decodeBase64((byte[])splitAuthorizationHeader[1].getBytes());
        String authHeader = new String(decodedAuthHeader, Charset.defaultCharset());
        String[] splitCredentials = authHeader.split(":", 2);
        if (splitCredentials.length == 2 && StringUtils.isNotBlank((String)splitCredentials[0]) && StringUtils.isNotBlank((String)splitCredentials[1])) {
            String appName = splitCredentials[0];
            String password = splitCredentials[1];
            String hash = AuthConfigurationUtil.getInstance().getClientAuthenticationHash(appName);
            if (!StringUtils.isNotBlank((String)hash)) {
                if (!log.isDebugEnabled()) return authenticationResult;
                log.debug((Object)("No matching application configuration found for :" + appName));
                return authenticationResult;
            }
            try {
                MessageDigest dgst = MessageDigest.getInstance("SHA-256");
                byte[] byteValue = dgst.digest(password.getBytes());
                StringBuilder sb = new StringBuilder();
                byte[] byArray = byteValue;
                int n = byArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        String hashFromRequest = sb.toString();
                        if (!hash.equals(hashFromRequest)) return authenticationResult;
                        authenticationResult.setAuthenticationStatus(AuthenticationStatus.SUCCESS);
                        if (!log.isDebugEnabled()) return authenticationResult;
                        log.debug((Object)("Client Authentication Successful for the application: " + appName));
                        return authenticationResult;
                    }
                    byte b = byArray[n2];
                    sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
                    ++n2;
                }
            }
            catch (NoSuchAlgorithmException e) {
                String errorMessage = "Error occurred while hashing the app data.";
                log.error((Object)errorMessage, (Throwable)e);
                throw new AuthenticationFailException(errorMessage);
            }
        }
        String errorMessage = "Error occurred while trying to authenticate. The auth application credentials are not defined correctly.";
        log.error((Object)errorMessage);
        throw new AuthenticationFailException(errorMessage);
    }
}

