/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service.handler.impl;

import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.AuthenticationResult;
import org.wso2.carbon.identity.auth.service.AuthenticationStatus;
import org.wso2.carbon.identity.auth.service.exception.AuthenticationFailException;
import org.wso2.carbon.identity.auth.service.handler.AuthenticationHandler;
import org.wso2.carbon.identity.auth.service.internal.AuthenticationServiceHolder;
import org.wso2.carbon.identity.auth.service.util.AuthConfigurationUtil;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class BasicAuthenticationHandler
extends AuthenticationHandler {
    private static final Log log = LogFactory.getLog(BasicAuthenticationHandler.class);
    private final String BASIC_AUTH_HEADER = "Basic";
    private final String USER_NAME = "userName";

    public void init(InitConfig initConfig) {
    }

    public String getName() {
        return "BasicAuthentication";
    }

    public int getPriority(MessageContext messageContext) {
        return this.getPriority(messageContext, 100);
    }

    public boolean canHandle(MessageContext messageContext) {
        return AuthConfigurationUtil.isAuthHeaderMatch(messageContext, "Basic");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AuthenticationResult doAuthenticate(MessageContext messageContext) throws AuthenticationFailException {
        AuthenticationResult authenticationResult;
        block11: {
            authenticationResult = new AuthenticationResult(AuthenticationStatus.FAILED);
            AuthenticationContext authenticationContext = (AuthenticationContext)messageContext;
            String authorizationHeader = authenticationContext.getAuthenticationRequest().getHeader("Authorization");
            String[] splitAuthorizationHeader = authorizationHeader.split(" ");
            if (splitAuthorizationHeader.length == 2) {
                byte[] decodedAuthHeader = Base64.decodeBase64((byte[])splitAuthorizationHeader[1].getBytes());
                String authHeader = new String(decodedAuthHeader, Charset.defaultCharset());
                String[] splitCredentials = authHeader.split(":", 2);
                if (splitCredentials.length == 2 && StringUtils.isNotBlank((String)splitCredentials[0]) && StringUtils.isNotBlank((String)splitCredentials[1])) {
                    String userName = splitCredentials[0];
                    String password = splitCredentials[1];
                    UserStoreManager userStoreManager = null;
                    try {
                        int tenantId = IdentityTenantUtil.getTenantIdOfUser((String)userName);
                        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
                        User user = new User();
                        user.setUserName(MultitenantUtils.getTenantAwareUsername((String)userName));
                        user.setTenantDomain(tenantDomain);
                        authenticationContext.setUser(user);
                        try {
                            PrivilegedCarbonContext.startTenantFlow();
                            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
                            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
                            UserRealm userRealm = AuthenticationServiceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId);
                            if (userRealm != null) {
                                userStoreManager = (UserStoreManager)userRealm.getUserStoreManager();
                                boolean isAuthenticated = userStoreManager.authenticate(MultitenantUtils.getTenantAwareUsername((String)userName), (Object)password);
                                if (isAuthenticated) {
                                    authenticationResult.setAuthenticationStatus(AuthenticationStatus.SUCCESS);
                                    String domain = UserCoreUtil.getDomainFromThreadLocal();
                                    if (StringUtils.isNotBlank((String)domain)) {
                                        user.setUserStoreDomain(domain);
                                    }
                                    authenticationContext.setUser(user);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Basic Authentication successful for the user: " + userName));
                                    }
                                    MDC.put((String)"userName", (String)userName);
                                }
                                break block11;
                            }
                            String errorMessage = "Error occurred while trying to load the user realm for the tenant: " + tenantId;
                            log.error((Object)errorMessage);
                            throw new AuthenticationFailException(errorMessage);
                        }
                        finally {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                    }
                    catch (UserStoreException e) {
                        String errorMessage = "Error occurred while trying to authenticate. " + e.getMessage();
                        log.error((Object)errorMessage);
                        throw new AuthenticationFailException(errorMessage);
                    }
                }
                String errorMessage = "Error occurred while trying to authenticate. The auth user credentials are not defined correctly.";
                log.error((Object)errorMessage);
                throw new AuthenticationFailException(errorMessage);
            }
            String errorMessage = "Error occurred while trying to authenticate. The Authorization header values are not defined correctly.";
            log.error((Object)errorMessage);
            throw new AuthenticationFailException(errorMessage);
        }
        return authenticationResult;
    }
}

