/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service.handler;

import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.AuthenticationResult;
import org.wso2.carbon.identity.auth.service.AuthenticationStatus;
import org.wso2.carbon.identity.auth.service.exception.AuthClientException;
import org.wso2.carbon.identity.auth.service.exception.AuthServerException;
import org.wso2.carbon.identity.auth.service.exception.AuthenticationFailException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.AbstractIdentityMessageHandler;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public abstract class AuthenticationHandler
extends AbstractIdentityMessageHandler {
    public int getPriority(MessageContext messageContext, int defaultValue) {
        int priority = super.getPriority(messageContext);
        return priority != -1 ? priority : defaultValue;
    }

    public final AuthenticationResult authenticate(MessageContext messageContext) throws AuthServerException, AuthenticationFailException, AuthClientException {
        AuthenticationResult authenticationResult = this.doAuthenticate(messageContext);
        this.postAuthenticate(messageContext, authenticationResult);
        return authenticationResult;
    }

    protected abstract AuthenticationResult doAuthenticate(MessageContext var1) throws AuthServerException, AuthenticationFailException, AuthClientException;

    protected void postAuthenticate(MessageContext messageContext, AuthenticationResult authenticationResult) {
        User user;
        AuthenticationContext authenticationContext = (AuthenticationContext)messageContext;
        if (AuthenticationStatus.SUCCESS.equals((Object)authenticationResult.getAuthenticationStatus()) && (user = authenticationContext.getUser()) != null && user.getTenantDomain() != null && user.getTenantDomain().equalsIgnoreCase(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain())) {
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()));
        }
    }
}

