/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service.factory;

import java.util.Enumeration;
import javax.servlet.http.Cookie;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.auth.service.AuthenticationRequest;
import org.wso2.carbon.identity.auth.service.exception.AuthClientException;
import org.wso2.carbon.identity.core.handler.AbstractIdentityHandler;

public class AuthenticationRequestBuilderFactory
extends AbstractIdentityHandler {
    public static final String TENANT_DOMAIN_PATTERN = "/t/([^/]+)";
    private static Log log = LogFactory.getLog(AuthenticationRequestBuilderFactory.class);
    private static AuthenticationRequestBuilderFactory authenticationRequestBuilderFactory = new AuthenticationRequestBuilderFactory();

    public static AuthenticationRequestBuilderFactory getInstance() {
        return authenticationRequestBuilderFactory;
    }

    public AuthenticationRequest.AuthenticationRequestBuilder createRequestBuilder(Request request, Response response) throws AuthClientException {
        AuthenticationRequest.AuthenticationRequestBuilder authenticationRequestBuilder = new AuthenticationRequest.AuthenticationRequestBuilder();
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            authenticationRequestBuilder.addAttribute(attributeName, request.getAttribute(attributeName));
        }
        authenticationRequestBuilder.addAttribute(HTTPConstants.MC_HTTP_SERVLETREQUEST, request);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            authenticationRequestBuilder.addHeader(headerName, request.getHeader(headerName));
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                authenticationRequestBuilder.addCookie(new AuthenticationRequest.CookieKey(cookie.getName(), cookie.getPath()), cookie);
            }
        }
        authenticationRequestBuilder.setRequestUri(request.getRequestURI());
        authenticationRequestBuilder.setContextPath(request.getContextPath());
        authenticationRequestBuilder.setMethod(request.getMethod());
        authenticationRequestBuilder.setRequest(request);
        return authenticationRequestBuilder;
    }

    public boolean canHandle(Request request, Response response) {
        return true;
    }

    public int getPriority() {
        return 10;
    }
}

