/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.catalina.connector.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.auth.service.exception.AuthRuntimeException;

public class AuthenticationRequest
implements Serializable {
    private static final long serialVersionUID = 5418537216546873566L;
    private static final Log log = LogFactory.getLog(AuthenticationRequest.class);
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Map<CookieKey, Cookie> cookies = new HashMap<CookieKey, Cookie>();
    protected Map<CookieKey, List<Cookie>> cookieListMap = new HashMap<CookieKey, List<Cookie>>();
    protected String contextPath;
    protected String method;
    protected String requestUri;
    private Request request;

    protected AuthenticationRequest(AuthenticationRequestBuilder builder) {
        this.attributes = builder.attributes;
        this.headers = builder.headers;
        this.cookies = builder.cookies;
        this.cookieListMap = builder.cookieListMap;
        this.contextPath = builder.contextPath;
        this.method = builder.method;
        this.requestUri = builder.requestUri;
        this.request = builder.request;
    }

    public Map<String, Object> getAttributeMap() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getHeaderMap() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Enumeration<String> getHeaders(String name) {
        String headerValue = this.headers.get(name);
        if (headerValue != null) {
            String[] multiValuedHeader = headerValue.split(",");
            return Collections.enumeration(Arrays.asList(multiValuedHeader));
        }
        return Collections.emptyEnumeration();
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public String getHeader(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            name = name.toLowerCase();
        }
        return this.headers.get(name);
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    @Deprecated
    public Map<CookieKey, Cookie> getCookieMap() {
        return Collections.unmodifiableMap(this.cookies);
    }

    public Map<CookieKey, List<Cookie>> getCookieListMap() {
        return Collections.unmodifiableMap(this.cookieListMap);
    }

    public Cookie[] getCookies() {
        Collection<List<Cookie>> cookieListCollection = this.getCookieListMap().values();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (List<Cookie> cookieList : cookieListCollection) {
            cookies.addAll(cookieList);
        }
        return cookies.toArray(new Cookie[cookies.size()]);
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getMethod() {
        return this.method;
    }

    public static class CookieKey {
        private String name;
        private String path;

        public CookieKey(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CookieKey cookieKey = (CookieKey)o;
            if (this.name != null ? !this.name.equals(cookieKey.name) : cookieKey.name != null) {
                return false;
            }
            return !(this.path == null ? cookieKey.path != null : !this.path.equals(cookieKey.path));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CookieKey{name='" + this.name + '\'' + ", path='" + this.path + '\'' + '}';
        }
    }

    public static class AuthenticationRequestBuilder {
        public Map<String, Object> attributes = new HashMap<String, Object>();
        private Map<String, String> headers = new HashMap<String, String>();
        private Map<CookieKey, Cookie> cookies = new HashMap<CookieKey, Cookie>();
        private Map<CookieKey, List<Cookie>> cookieListMap = new HashMap<CookieKey, List<Cookie>>();
        private String contextPath;
        private String method;
        private String requestUri;
        private Request request;

        public AuthenticationRequestBuilder setMethod(String method) {
            this.method = method;
            return this;
        }

        public AuthenticationRequestBuilder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public AuthenticationRequestBuilder addAttribute(String name, Object value) {
            if (this.attributes.containsKey(name)) {
                throw new AuthRuntimeException("Attributes map trying to override existing attribute " + name);
            }
            this.attributes.put(name, value);
            return this;
        }

        public AuthenticationRequestBuilder addHeader(String name, String value) {
            if (this.headers.containsKey(name)) {
                throw new AuthRuntimeException("Headers map trying to override existing header " + name);
            }
            this.headers.put(name, value);
            return this;
        }

        public AuthenticationRequestBuilder addCookie(CookieKey cookieKey, Cookie value) {
            if (this.cookies.containsKey(cookieKey)) {
                log.warn((Object)("Overriding existing cookie '" + cookieKey.toString() + "' in cookie map"));
            }
            this.cookies.put(cookieKey, value);
            List<Cookie> cookieValues = this.cookieListMap.containsKey(cookieKey) ? this.cookieListMap.get(cookieKey) : new ArrayList<Cookie>();
            cookieValues.add(value);
            this.cookieListMap.put(cookieKey, cookieValues);
            return this;
        }

        public AuthenticationRequestBuilder setRequestUri(String requestUri) {
            this.requestUri = requestUri;
            return this;
        }

        public AuthenticationRequestBuilder setRequest(Request request) {
            this.request = request;
            return this;
        }

        public AuthenticationRequest build() {
            return new AuthenticationRequest(this);
        }
    }
}

