/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.AuthenticationRequest;
import org.wso2.carbon.identity.auth.service.AuthenticationResult;
import org.wso2.carbon.identity.auth.service.exception.AuthClientException;
import org.wso2.carbon.identity.auth.service.exception.AuthServerException;
import org.wso2.carbon.identity.auth.service.exception.AuthenticationFailException;
import org.wso2.carbon.identity.auth.service.handler.AuthenticationHandler;
import org.wso2.carbon.identity.auth.service.handler.HandlerManager;
import org.wso2.carbon.identity.auth.service.handler.ResourceHandler;
import org.wso2.carbon.identity.auth.service.internal.AuthenticationServiceHolder;
import org.wso2.carbon.identity.auth.service.module.ResourceConfig;
import org.wso2.carbon.identity.auth.service.module.ResourceConfigKey;
import org.wso2.carbon.identity.auth.service.util.AuthConfigurationUtil;
import org.wso2.carbon.identity.core.handler.IdentityHandler;
import org.wso2.carbon.identity.core.handler.InitConfig;

public class AuthenticationManager
implements IdentityHandler {
    private static final Log log = LogFactory.getLog(AuthenticationManager.class);
    private static AuthenticationManager authenticationManager = new AuthenticationManager();

    public static AuthenticationManager getInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AuthenticationManager instance created.");
        }
        return authenticationManager;
    }

    public ResourceConfig getSecuredResource(ResourceConfigKey resourceConfigKey) {
        ResourceConfig securedResourceConfig;
        block1: {
            ResourceHandler resourceHandler;
            securedResourceConfig = AuthConfigurationUtil.getInstance().getSecuredConfig(resourceConfigKey);
            if (securedResourceConfig != null) break block1;
            List<ResourceHandler> resourceHandlers = AuthenticationServiceHolder.getInstance().getResourceHandlers();
            Iterator<ResourceHandler> iterator = resourceHandlers.iterator();
            while (iterator.hasNext() && (securedResourceConfig = (resourceHandler = iterator.next()).getSecuredResource(resourceConfigKey)) == null) {
            }
        }
        return securedResourceConfig;
    }

    public AuthenticationResult authenticate(AuthenticationContext authenticationContext) throws AuthServerException, AuthClientException, AuthenticationFailException {
        if (log.isDebugEnabled() && authenticationContext != null && authenticationContext.getAuthenticationRequest() != null) {
            AuthenticationRequest authenticationRequest = authenticationContext.getAuthenticationRequest();
            String contextPath = authenticationRequest.getContextPath();
            log.debug((Object)("Context Path : " + contextPath + " started to authenticate."));
        }
        List<AuthenticationHandler> authenticationHandlerList = AuthenticationServiceHolder.getInstance().getAuthenticationHandlers();
        authenticationHandlerList = this.filterAuthenticationHandlers(authenticationContext, authenticationHandlerList);
        AuthenticationHandler authenticationHandler = HandlerManager.getInstance().getFirstPriorityHandler(authenticationHandlerList, true, authenticationContext);
        if (authenticationHandler == null) {
            throw new AuthenticationFailException("AuthenticationHandler not found.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("AuthenticationHandler found : " + ((Object)((Object)authenticationHandler)).getClass().getName() + "."));
        }
        AuthenticationResult authenticationResult = authenticationHandler.authenticate(authenticationContext);
        if (log.isDebugEnabled() && authenticationResult != null) {
            log.debug((Object)("AuthenticationResult : " + (Object)((Object)authenticationResult.getAuthenticationStatus()) + "."));
        }
        return authenticationResult;
    }

    private List<AuthenticationHandler> filterAuthenticationHandlers(AuthenticationContext authenticationContext, List<AuthenticationHandler> handlers) {
        ResourceConfig resourceConfig = this.getResourceConfig(authenticationContext);
        String allowedAuthHandlers = resourceConfig.getAllowedAuthHandlers();
        List<String> allowedAuthenticationHandlersForResource = AuthConfigurationUtil.getInstance().buildAllowedAuthenticationHandlers(allowedAuthHandlers);
        return handlers.stream().filter(handler -> this.isHandlerAllowedForResource(allowedAuthenticationHandlersForResource, (AuthenticationHandler)((Object)handler))).collect(Collectors.toList());
    }

    private boolean isHandlerAllowedForResource(List<String> allowedAuthenticationHandlersForResource, AuthenticationHandler handler) {
        return allowedAuthenticationHandlersForResource.contains(handler.getName());
    }

    private ResourceConfig getResourceConfig(AuthenticationContext context) {
        AuthenticationRequest authenticationRequest = context.getAuthenticationRequest();
        String requestUri = authenticationRequest.getRequestUri();
        String method = authenticationRequest.getMethod();
        ResourceConfigKey resourceConfigKey = new ResourceConfigKey(requestUri, method);
        return this.getSecuredResource(resourceConfigKey);
    }

    public void init(InitConfig initConfig) {
    }

    public String getName() {
        return "DefaultAuthenticationManager";
    }

    public boolean isEnabled() {
        return true;
    }

    public int getPriority() {
        return 1;
    }
}

