/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.validation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.util.MeteringAccessValidationUtils;
import org.wso2.carbon.throttling.agent.validation.ValidationException;
import org.wso2.carbon.throttling.agent.validation.ValidationInfo;

public class ValidationInfoRetriever {
    private static final Log log = LogFactory.getLog(ValidationInfoRetriever.class);
    UserRegistry governanceSystemRegistry;

    public ValidationInfoRetriever(UserRegistry governanceSystemRegistry) {
        this.governanceSystemRegistry = governanceSystemRegistry;
    }

    public ValidationInfo getValidationInfo(String action, int tenantId) throws ValidationException {
        ValidationInfo validationInfo = new ValidationInfo();
        Resource validationInfoResource = this.getResource(tenantId);
        if (validationInfoResource == null) {
            return validationInfo;
        }
        this.checkAction("all_actions", validationInfoResource, validationInfo);
        if (validationInfo.isActionBlocked()) {
            return validationInfo;
        }
        this.checkAction(action, validationInfoResource, validationInfo);
        return validationInfo;
    }

    public ValidationInfo getValidationInfo(String[] actions, int tenantId) throws ValidationException {
        ValidationInfo validationInfo = new ValidationInfo();
        Resource validationInfoResource = this.getResource(tenantId);
        if (validationInfoResource == null) {
            return validationInfo;
        }
        this.checkAction("all_actions", validationInfoResource, validationInfo);
        if (validationInfo.isActionBlocked()) {
            return validationInfo;
        }
        for (String action : actions) {
            this.checkAction(action, validationInfoResource, validationInfo);
            if (!validationInfo.isActionBlocked()) continue;
            return validationInfo;
        }
        return validationInfo;
    }

    private Resource getResource(int tenantId) throws ValidationException {
        String tenantValidationInfoResourcePath = "/repository/components/org.wso2.carbon.validations/" + tenantId;
        Resource tenantValidationInfoResource = null;
        try {
            if (this.governanceSystemRegistry.resourceExists(tenantValidationInfoResourcePath)) {
                tenantValidationInfoResource = this.governanceSystemRegistry.get(tenantValidationInfoResourcePath);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting the tenant validation info for tenant:" + tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new ValidationException(msg, (Exception)((Object)e));
        }
        return tenantValidationInfoResource;
    }

    private void checkAction(String action, Resource tenantValidationInfoResource, ValidationInfo validationInfo) {
        String blockActionStr = tenantValidationInfoResource.getProperty(MeteringAccessValidationUtils.generateIsBlockedPropertyKey((String)action));
        if ("true".equals(blockActionStr)) {
            validationInfo.setActionBlocked(true);
            String blockActionMsg = tenantValidationInfoResource.getProperty(MeteringAccessValidationUtils.generateErrorMsgPropertyKey((String)action));
            validationInfo.setBlockedActionMsg(blockActionMsg);
        }
    }
}

