/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.listeners;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.transports.metering.MeteredServletRequest;
import org.wso2.carbon.throttling.agent.cache.ThrottlingActionInfo;
import org.wso2.carbon.throttling.agent.cache.ThrottlingInfoCache;
import org.wso2.carbon.throttling.agent.internal.ThrottlingAgentServiceComponent;
import org.wso2.carbon.user.api.UserStoreException;

public class ServiceRequestListener
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(ServiceRequestListener.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        AxisService service;
        Parameter param;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Staring throttling handler invocation. Incoming message: " + messageContext.getEnvelope().toString()));
        }
        if ((param = (service = messageContext.getAxisService()).getParameter("adminService")) != null && "true".equals(param.getValue())) {
            return Handler.InvocationResponse.CONTINUE;
        }
        int tenantId = this.getTenantId(messageContext);
        if (tenantId <= 0) {
            return Handler.InvocationResponse.CONTINUE;
        }
        ThrottlingInfoCache throttlingInfoCache = ThrottlingAgentServiceComponent.getThrottlingAgent().getThrottlingInfoCache();
        String[] actions = new String[]{"service_in_bandwith_action", "service_out_bandwith_action", "service_request_action", "service_response_action"};
        ThrottlingActionInfo actionInfo = throttlingInfoCache.getTenantThrottlingInfo(tenantId).getThrottlingActionInfo(actions);
        if (actionInfo.isBlocked()) {
            String blockedMsg = actionInfo.getMessage();
            String msg = "The throttling action is blocked. message: " + blockedMsg;
            log.error((Object)msg);
            throw new AxisFault(blockedMsg);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private int getTenantId(MessageContext messageContext) {
        int domainNameEndIndex;
        int domainNameStartIndex;
        String domainName;
        Object obj = messageContext.getProperty("transport.http.servletRequest");
        if (obj == null) {
            log.debug((Object)"Servlet request is null. Skip monitoring.");
            return 0;
        }
        if (!(obj instanceof MeteredServletRequest)) {
            log.debug((Object)"HttpServletRequest is not of type MeteredServletRequest. Skip monitoring.");
            return 0;
        }
        MeteredServletRequest servletRequest = (MeteredServletRequest)obj;
        String address = servletRequest.getRequestURI();
        String servicesPrefix = "/services/t/";
        if (address != null && address.contains(servicesPrefix) && (domainName = address.substring(domainNameStartIndex, (domainNameEndIndex = address.indexOf(47, domainNameStartIndex = address.indexOf(servicesPrefix) + servicesPrefix.length())) == -1 ? address.length() : domainNameEndIndex)) != null) {
            try {
                return ThrottlingAgentServiceComponent.getThrottlingAgent().getRealmService().getTenantManager().getTenantId(domainName);
            }
            catch (UserStoreException e) {
                log.error((Object)"An error occurred while obtaining the tenant id.", (Throwable)e);
            }
        }
        return 0;
    }
}

