/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.listeners;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.throttling.agent.cache.TenantThrottlingInfo;
import org.wso2.carbon.throttling.agent.cache.ThrottlingActionInfo;
import org.wso2.carbon.throttling.agent.internal.ThrottlingAgentServiceComponent;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManagerListener;

public class PerUserAddListener
extends AbstractUserStoreManagerListener {
    private static final Log log = LogFactory.getLog(PerUserAddListener.class);

    public int getExecutionOrderId() {
        return 10;
    }

    public boolean addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        ThrottlingActionInfo actionInfo;
        if ("false".equals(ServerConfiguration.getInstance().getFirstProperty("IsCloudDeployment"))) {
            log.info((Object)"Omitting executing throttling rules becasue this is not a cloud deployment.");
            return true;
        }
        int tenantId = userStoreManager.getTenantId();
        if (tenantId == -1234) {
            return true;
        }
        String[] users = userStoreManager.listUsers("*", -1);
        if (users.length <= 1) {
            return true;
        }
        try {
            ThrottlingAgentServiceComponent.getThrottlingAgent().executeManagerThrottlingRules(tenantId);
            ThrottlingAgentServiceComponent.getThrottlingAgent().updateThrottlingCacheForTenant();
        }
        catch (Exception e1) {
            String msg = "Error in executing the throttling rules in manager.";
            log.error((Object)(msg + " tenantId: " + tenantId + "."), (Throwable)e1);
            throw new UserStoreException(msg, (Throwable)e1);
        }
        TenantThrottlingInfo throttlingInfo = ThrottlingAgentServiceComponent.getThrottlingAgent().getThrottlingInfoCache().getTenantThrottlingInfo(tenantId);
        if (throttlingInfo != null && (actionInfo = throttlingInfo.getThrottlingActionInfo("add_user_action")) != null && actionInfo.isBlocked()) {
            String blockedMsg = actionInfo.getMessage();
            String msg = "The add user action is blocked. message: " + blockedMsg + ".";
            log.error((Object)msg);
            throw new UserStoreException(blockedMsg);
        }
        return true;
    }
}

