/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.listeners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.URLMatcher;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.throttling.agent.cache.TenantThrottlingInfo;
import org.wso2.carbon.throttling.agent.cache.ThrottlingActionInfo;
import org.wso2.carbon.throttling.agent.internal.ThrottlingAgentServiceComponent;

public class PerRegistryRequestListener
extends Handler {
    private static final Log log = LogFactory.getLog(PerRegistryRequestListener.class);

    public void put(RequestContext context) throws RegistryException {
        this.validateRegistryAction("in_data_action");
    }

    public void importResource(RequestContext context) throws RegistryException {
        this.validateRegistryAction("in_data_action");
    }

    public Resource get(RequestContext context) throws RegistryException {
        this.validateRegistryAction("out_data_action");
        return null;
    }

    public void dump(RequestContext requestContext) throws RegistryException {
        this.validateRegistryAction("out_data_action");
    }

    public void restore(RequestContext requestContext) throws RegistryException {
        this.validateRegistryAction("in_data_action");
    }

    private void validateRegistryAction(String action) throws RegistryException {
        ThrottlingActionInfo actionInfo;
        if (CurrentSession.getCallerTenantId() == -1234 || CurrentSession.getTenantId() == -1234) {
            return;
        }
        if ("wso2.system.user".equals(CurrentSession.getUser()) || "wso2.anonymous.user".equals(CurrentSession.getUser())) {
            return;
        }
        if (CurrentSession.getAttribute((String)"registryActionValidated") != null) {
            return;
        }
        CurrentSession.setAttribute((String)"registryActionValidated", (Object)true);
        int tenantId = CurrentSession.getTenantId();
        TenantThrottlingInfo tenantThrottlingInfo = ThrottlingAgentServiceComponent.getThrottlingAgent().getThrottlingInfoCache().getTenantThrottlingInfo(tenantId);
        if (tenantThrottlingInfo != null && (actionInfo = tenantThrottlingInfo.getThrottlingActionInfo(action)) != null && actionInfo.isBlocked()) {
            String blockedMsg = actionInfo.getMessage();
            String msg = "The throttling action is blocked. message: " + blockedMsg + ", action: " + action + ".";
            log.error((Object)msg);
            throw new RegistryException(blockedMsg);
        }
    }

    public static void registerPerRegistryRequestListener(RegistryContext registryContext) {
        HandlerManager handlerManager = registryContext.getHandlerManager();
        PerRegistryRequestListener storeBandwidthHandler = new PerRegistryRequestListener();
        URLMatcher anyUrlMatcher = new URLMatcher();
        anyUrlMatcher.setPattern(".*");
        String[] applyingFilters = new String[]{"PUT", "IMPORT", "GET", "DUMP", "RESTORE"};
        handlerManager.addHandlerWithPriority(applyingFilters, (Filter)anyUrlMatcher, (Handler)storeBandwidthHandler);
    }
}

