/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.internal;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.util.StratosConfiguration;
import org.wso2.carbon.throttling.agent.ThrottlingAgent;
import org.wso2.carbon.throttling.agent.cache.Axis2ConfigurationContextObserverImpl;
import org.wso2.carbon.throttling.agent.cache.ThrottlingInfoCache;
import org.wso2.carbon.throttling.agent.listeners.WebAppRequestListener;
import org.wso2.carbon.tomcat.ext.valves.TomcatValveContainer;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.throttling.agent", immediate=true)
public class ThrottlingAgentServiceComponent {
    private static Log log = LogFactory.getLog(ThrottlingAgentServiceComponent.class);
    private static ThrottlingAgent throttlingAgent;
    private static RealmService realmService;
    private static RegistryService registryService;
    private static ConfigurationContextService contextService;
    private static StratosConfiguration stratosConfiguration;

    @Activate
    protected void activate(ComponentContext context) {
        try {
            BundleContext bundleContext = context.getBundleContext();
            throttlingAgent = new ThrottlingAgent(bundleContext);
            throttlingAgent.setConfigurationContextService(contextService);
            throttlingAgent.setRealmService(realmService);
            throttlingAgent.setRegistryService(registryService);
            throttlingAgent.setStratosConfiguration(stratosConfiguration);
            try {
                throttlingAgent.init();
            }
            catch (RegistryException e) {
                String errMessage = "Failed to initialize throttling agent.";
                log.error((Object)errMessage, (Throwable)e);
                throw new RuntimeException(errMessage, e);
            }
            if ("true".equals(ServerConfiguration.getInstance().getFirstProperty("EnableMetering"))) {
                ArrayList<WebAppRequestListener> valves = new ArrayList<WebAppRequestListener>();
                valves.add(new WebAppRequestListener(throttlingAgent));
                TomcatValveContainer.addValves(valves);
                this.registerAxis2ConfigurationContextObserver(bundleContext, throttlingAgent.getThrottlingInfoCache());
            } else {
                log.debug((Object)"WebAppRequestListener valve was not added because metering is disabled in the configuration");
                log.debug((Object)"Axis2ConfigurationContextObserver was not registered because metering is disabled");
            }
            this.registerThrottlingAgent(bundleContext);
            log.debug((Object)"Multitenancy Throttling Agent bundle is activated.");
        }
        catch (Throwable e) {
            log.error((Object)"Multitenancy Throttling Agent bundle failed activating.", e);
        }
    }

    private void registerAxis2ConfigurationContextObserver(BundleContext bundleContext, ThrottlingInfoCache cache) {
        bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new Axis2ConfigurationContextObserverImpl(cache), null);
    }

    public void registerThrottlingAgent(BundleContext bundleContext) {
        try {
            bundleContext.registerService(ThrottlingAgent.class.getName(), (Object)throttlingAgent, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Multitenancy Throttling Agent bundle is deactivated ******* ");
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        ThrottlingAgentServiceComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ThrottlingAgentServiceComponent.registryService = null;
        throttlingAgent.setRegistryService(null);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        ThrottlingAgentServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        ThrottlingAgentServiceComponent.realmService = null;
        throttlingAgent.setRealmService(null);
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        ThrottlingAgentServiceComponent.contextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        ThrottlingAgentServiceComponent.contextService = null;
        throttlingAgent.setConfigurationContextService(null);
    }

    public static ThrottlingAgent getThrottlingAgent() {
        return throttlingAgent;
    }

    @Reference(name="stratos.config.service", service=StratosConfiguration.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetStratosConfigurationService")
    protected void setStratosConfigurationService(StratosConfiguration stratosConfigService) {
        stratosConfiguration = stratosConfigService;
    }

    protected void unsetStratosConfigurationService(StratosConfiguration ccService) {
        stratosConfiguration = null;
        throttlingAgent.setStratosConfiguration(null);
    }
}

