/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.conf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.stratos.common.util.CommonUtil;

public class ThrottlingAgentConfiguration {
    private static final Log log = LogFactory.getLog(ThrottlingAgentConfiguration.class);
    private static final String CONFIG_NS = "http://wso2.com/carbon/multitenancy/throttling/agent/config";
    private static final String PARAMTERS_ELEMENT_NAME = "parameters";
    private static final String PARAMTER_ELEMENT_NAME = "parameter";
    private static final String PARAMTER_NAME_ATTR_NAME = "name";
    private Map<String, String> parameters = new HashMap<String, String>();

    public ThrottlingAgentConfiguration(String throttlingConfigFile) throws Exception {
        try {
            OMElement meteringConfig = CommonUtil.buildOMElement((InputStream)new FileInputStream(throttlingConfigFile));
            this.deserialize(meteringConfig);
        }
        catch (FileNotFoundException e) {
            String msg = "Unable to find the file: " + throttlingConfigFile + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public void deserialize(OMElement throttlingConfigEle) throws Exception {
        Iterator meteringConfigChildIt = throttlingConfigEle.getChildElements();
        while (meteringConfigChildIt.hasNext()) {
            OMElement meteringConfigChildEle;
            Object meteringConfigChild = meteringConfigChildIt.next();
            if (!(meteringConfigChild instanceof OMElement) || !new QName(CONFIG_NS, PARAMTERS_ELEMENT_NAME, "").equals((meteringConfigChildEle = (OMElement)meteringConfigChild).getQName())) continue;
            Iterator parametersChildIt = meteringConfigChildEle.getChildElements();
            while (parametersChildIt.hasNext()) {
                OMElement parameterChildEle;
                Object taskConfigChild = parametersChildIt.next();
                if (!(taskConfigChild instanceof OMElement) || !new QName(CONFIG_NS, PARAMTER_ELEMENT_NAME, "").equals((parameterChildEle = (OMElement)taskConfigChild).getQName())) continue;
                String parameterName = parameterChildEle.getAttributeValue(new QName(PARAMTER_NAME_ATTR_NAME));
                String parameterValue = parameterChildEle.getText();
                this.parameters.put(parameterName, parameterValue);
            }
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

