/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.cache;

import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.util.MeteringAccessValidationUtils;
import org.wso2.carbon.throttling.agent.cache.TenantThrottlingInfo;
import org.wso2.carbon.throttling.agent.cache.ThrottlingActionInfo;
import org.wso2.carbon.throttling.agent.cache.ThrottlingInfoCache;

public class ThrottlingInfoCacheUpdaterTask
implements Runnable {
    private static final Log log = LogFactory.getLog(ThrottlingInfoCacheUpdaterTask.class);
    private ThrottlingInfoCache cache;
    private UserRegistry governanceSystemRegistry;

    public ThrottlingInfoCacheUpdaterTask(ThrottlingInfoCache cache, UserRegistry governanceSystemRegistry) {
        this.cache = cache;
        this.governanceSystemRegistry = governanceSystemRegistry;
    }

    @Override
    public void run() {
        log.info((Object)"Running throttling info cache updater task");
        Set<Integer> activeTenants = this.cache.getActiveTenants();
        for (Integer tenant : activeTenants) {
            String tenantValidationInfoResourcePath = "/repository/components/org.wso2.carbon.validations/" + tenant;
            try {
                if (!this.governanceSystemRegistry.resourceExists(tenantValidationInfoResourcePath)) continue;
                Resource tenantValidationInfoResource = this.governanceSystemRegistry.get(tenantValidationInfoResourcePath);
                Properties properties = tenantValidationInfoResource.getProperties();
                Set actions = MeteringAccessValidationUtils.getAvailableActions((Properties)properties);
                for (String action : actions) {
                    String blocked = tenantValidationInfoResource.getProperty(MeteringAccessValidationUtils.generateIsBlockedPropertyKey((String)action));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Action: " + action + " blocked: " + blocked + " tenant: " + tenant));
                    }
                    String blockMessage = tenantValidationInfoResource.getProperty(MeteringAccessValidationUtils.generateErrorMsgPropertyKey((String)action));
                    TenantThrottlingInfo tenantThrottlingInfo = this.cache.getTenantThrottlingInfo(tenant);
                    tenantThrottlingInfo.updateThrottlingActionInfo(action, new ThrottlingActionInfo("true".equals(blocked), blockMessage));
                }
            }
            catch (RegistryException re) {
                String msg = "Error while getting throttling info for tenant " + tenant + ".";
                log.error((Object)msg, (Throwable)re);
            }
        }
    }
}

