/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.cache;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.util.MeteringAccessValidationUtils;
import org.wso2.carbon.throttling.agent.cache.TenantThrottlingInfo;
import org.wso2.carbon.throttling.agent.cache.ThrottlingActionInfo;
import org.wso2.carbon.throttling.agent.internal.ThrottlingAgentServiceComponent;

public class ThrottlingInfoCache {
    private static final Log log = LogFactory.getLog(ThrottlingInfoCache.class);
    private Map<Integer, TenantThrottlingInfo> tenantThrottlingInfoMap = new ConcurrentHashMap<Integer, TenantThrottlingInfo>();

    public void addTenant(int tenantId) {
        if (!this.tenantThrottlingInfoMap.containsKey(tenantId)) {
            this.tenantThrottlingInfoMap.put(tenantId, this.getTenantThrottlingInfoFromRegistry(tenantId));
        }
    }

    public void deleteTenant(int tenantId) {
        this.tenantThrottlingInfoMap.remove(tenantId);
    }

    public Set<Integer> getActiveTenants() {
        return this.tenantThrottlingInfoMap.keySet();
    }

    public void updateThrottlingActionInfo(int tenantId, String action, ThrottlingActionInfo throttlingActionInfo) {
        TenantThrottlingInfo throttlingInfo = this.tenantThrottlingInfoMap.get(tenantId);
        throttlingInfo.updateThrottlingActionInfo(action, throttlingActionInfo);
    }

    public ThrottlingActionInfo getThrottlingActionInfo(int tenantId, String action) {
        if (this.tenantThrottlingInfoMap.get(tenantId) != null) {
            return this.tenantThrottlingInfoMap.get(tenantId).getThrottlingActionInfo(action);
        }
        return null;
    }

    public TenantThrottlingInfo getTenantThrottlingInfo(int tenantId) {
        if (!this.tenantThrottlingInfoMap.containsKey(tenantId)) {
            this.tenantThrottlingInfoMap.put(tenantId, this.getTenantThrottlingInfoFromRegistry(tenantId));
        }
        return this.tenantThrottlingInfoMap.get(tenantId);
    }

    private TenantThrottlingInfo getTenantThrottlingInfoFromRegistry(int tenantId) {
        log.info((Object)"Tenant throttling info is not in the cache. Hence, getting it from registry");
        RegistryService registryService = ThrottlingAgentServiceComponent.getThrottlingAgent().getRegistryService();
        TenantThrottlingInfo tenantThrottlingInfo = new TenantThrottlingInfo();
        try {
            UserRegistry superTenantGovernanceRegistry = (UserRegistry)registryService.getGovernanceSystemRegistry();
            String tenantValidationInfoResourcePath = "/repository/components/org.wso2.carbon.validations/" + tenantId;
            if (superTenantGovernanceRegistry.resourceExists(tenantValidationInfoResourcePath)) {
                Resource tenantValidationInfoResource = superTenantGovernanceRegistry.get(tenantValidationInfoResourcePath);
                Properties properties = tenantValidationInfoResource.getProperties();
                Set actions = MeteringAccessValidationUtils.getAvailableActions((Properties)properties);
                for (String action : actions) {
                    String blocked = tenantValidationInfoResource.getProperty(MeteringAccessValidationUtils.generateIsBlockedPropertyKey((String)action));
                    String blockMessage = tenantValidationInfoResource.getProperty(MeteringAccessValidationUtils.generateErrorMsgPropertyKey((String)action));
                    tenantThrottlingInfo.updateThrottlingActionInfo(action, new ThrottlingActionInfo("true".equals(blocked), blockMessage));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while obtaining governance system registry from registry service", (Throwable)e);
        }
        return tenantThrottlingInfo;
    }
}

