/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent;

import java.io.File;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.util.MeteringAccessValidationUtils;
import org.wso2.carbon.stratos.common.util.StratosConfiguration;
import org.wso2.carbon.throttling.agent.cache.TenantThrottlingInfo;
import org.wso2.carbon.throttling.agent.cache.ThrottlingActionInfo;
import org.wso2.carbon.throttling.agent.cache.ThrottlingInfoCache;
import org.wso2.carbon.throttling.agent.cache.ThrottlingInfoCacheUpdaterTask;
import org.wso2.carbon.throttling.agent.client.MultitenancyThrottlingServiceClient;
import org.wso2.carbon.throttling.agent.client.ThrottlingRuleInvoker;
import org.wso2.carbon.throttling.agent.conf.ThrottlingAgentConfiguration;
import org.wso2.carbon.throttling.agent.listeners.PerRegistryRequestListener;
import org.wso2.carbon.throttling.agent.listeners.PerUserAddListener;
import org.wso2.carbon.user.core.listener.UserStoreManagerListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ThrottlingAgent {
    private static final Log log = LogFactory.getLog(ThrottlingAgent.class);
    private static final String CONFIG_FILE = "throttling-agent-config.xml";
    private static final String MANAGER_SERVER_URL_PARAM_NAME = "managerServiceUrl";
    private static final String USERNAME_PARAM_NAME = "userName";
    private static final String PASSWORD_PARAM_NAME = "password";
    private ThrottlingAgentConfiguration configuration;
    private RegistryService registryService;
    private RealmService realmService;
    private ConfigurationContextService configurationContextService;
    private ThrottlingInfoCache throttlingInfoCache;
    private ServiceTracker throttlingRuleInvokerTracker = null;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThrottlingAgentThreadFactory());
    private BundleContext bundleContext;
    private StratosConfiguration stratosConfiguration = null;

    public StratosConfiguration getStratosConfiguration() {
        return this.stratosConfiguration;
    }

    public void setStratosConfiguration(StratosConfiguration stratosConfiguration) {
        this.stratosConfiguration = stratosConfiguration;
    }

    public ThrottlingAgent(BundleContext bundleContext) throws Exception {
        this.throttlingInfoCache = new ThrottlingInfoCache();
        this.bundleContext = bundleContext;
    }

    public void init() throws RegistryException {
        if ("true".equals(ServerConfiguration.getInstance().getFirstProperty("EnableMetering"))) {
            UserRegistry superTenantGovernanceRegistry = this.registryService.getGovernanceSystemRegistry();
            this.scheduler.scheduleAtFixedRate(new ThrottlingInfoCacheUpdaterTask(this.throttlingInfoCache, superTenantGovernanceRegistry), 2L, 15L, TimeUnit.MINUTES);
            PerRegistryRequestListener.registerPerRegistryRequestListener(RegistryContext.getBaseInstance());
            if (this.bundleContext != null) {
                this.bundleContext.registerService(UserStoreManagerListener.class.getName(), (Object)new PerUserAddListener(), null);
            }
        }
        this.throttlingRuleInvokerTracker = new ServiceTracker(this.bundleContext, ThrottlingRuleInvoker.class.getName(), null);
        this.throttlingRuleInvokerTracker.open();
    }

    public ThrottlingInfoCache getThrottlingInfoCache() {
        return this.throttlingInfoCache;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRealmService(RealmService realmService) {
        this.realmService = realmService;
    }

    public RealmService getRealmService() {
        return this.realmService;
    }

    public void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        this.configurationContextService = configurationContextService;
    }

    public ConfigurationContextService getConfigurationContextService() {
        return this.configurationContextService;
    }

    public void updateThrottlingCacheForTenant() throws Exception {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantValidationInfoResourcePath = "/repository/components/org.wso2.carbon.validations/" + tenantId;
        try {
            if (this.registryService.getGovernanceSystemRegistry().resourceExists(tenantValidationInfoResourcePath)) {
                Resource tenantValidationInfoResource = this.registryService.getGovernanceSystemRegistry().get(tenantValidationInfoResourcePath);
                Properties properties = tenantValidationInfoResource.getProperties();
                Set actions = MeteringAccessValidationUtils.getAvailableActions((Properties)properties);
                for (String action : actions) {
                    String blocked = tenantValidationInfoResource.getProperty(MeteringAccessValidationUtils.generateIsBlockedPropertyKey((String)action));
                    String blockMessage = tenantValidationInfoResource.getProperty(MeteringAccessValidationUtils.generateErrorMsgPropertyKey((String)action));
                    TenantThrottlingInfo tenantThrottlingInfo = this.throttlingInfoCache.getTenantThrottlingInfo(tenantId);
                    if (tenantThrottlingInfo == null) {
                        this.throttlingInfoCache.addTenant(tenantId);
                        tenantThrottlingInfo = this.throttlingInfoCache.getTenantThrottlingInfo(tenantId);
                    }
                    tenantThrottlingInfo.updateThrottlingActionInfo(action, new ThrottlingActionInfo("true".equals(blocked), blockMessage));
                }
            }
        }
        catch (RegistryException re) {
            String msg = "Error while getting throttling info for tenant " + tenantId + ".";
            log.error((Object)msg, (Throwable)re);
        }
    }

    private ThrottlingAgentConfiguration loadThrottlingConfiguration() throws Exception {
        ThrottlingAgentConfiguration throttlingAgentConfig = null;
        String configFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + CONFIG_FILE;
        if (new File(configFileName).exists()) {
            throttlingAgentConfig = new ThrottlingAgentConfiguration(configFileName);
        } else {
            log.warn((Object)("Throttling agent config file is not present. File name: " + configFileName + "."));
        }
        return throttlingAgentConfig;
    }

    public ThrottlingRuleInvoker getThrottlingRuleInvoker() throws Exception {
        ThrottlingRuleInvoker embeddedRuleInvoker = (ThrottlingRuleInvoker)this.throttlingRuleInvokerTracker.getService();
        if (embeddedRuleInvoker != null) {
            return embeddedRuleInvoker;
        }
        if (this.stratosConfiguration == null) {
            String msg = "Neither embedded nor web service implementation of throttling rule invoker found.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        String serverUrl = this.stratosConfiguration.getManagerServiceUrl();
        String userName = this.stratosConfiguration.getAdminUserName();
        String password = this.stratosConfiguration.getAdminPassword();
        return new MultitenancyThrottlingServiceClient(serverUrl, userName, password);
    }

    public void executeManagerThrottlingRules(int tenantId) throws Exception {
        ThrottlingRuleInvoker client = this.getThrottlingRuleInvoker();
        client.executeThrottlingRules(tenantId);
    }

    public void executeThrottlingRules(int tenantId) {
        try {
            this.executeManagerThrottlingRules(tenantId);
            this.updateThrottlingCacheForTenant();
        }
        catch (Exception e) {
            log.error((Object)"Error in executing throttling rules");
        }
    }

    class ThrottlingAgentThreadFactory
    implements ThreadFactory {
        private int counter = 0;

        ThrottlingAgentThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ThrottlingAgentThreadFactory-" + this.counter++);
        }
    }
}

