/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.common;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.wso2.carbon.apimgt.api.APIConsumer;
import org.wso2.carbon.apimgt.api.APIDefinition;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIMgtAuthorizationFailedException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.impl.APIManagerFactory;
import org.wso2.carbon.apimgt.impl.definitions.OASParserUtil;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RestApiCommonUtil {
    public static final ThreadLocal userThreadLocal = new ThreadLocal();
    private static final Log log = LogFactory.getLog(RestApiCommonUtil.class);

    public static void unsetThreadLocalRequestedTenant() {
        userThreadLocal.remove();
    }

    public static String getThreadLocalRequestedTenant() {
        return (String)userThreadLocal.get();
    }

    public static void setThreadLocalRequestedTenant(String user) {
        userThreadLocal.set(user);
    }

    public static APIProvider getLoggedInUserProvider() throws APIManagementException {
        return APIManagerFactory.getInstance().getAPIProvider(RestApiCommonUtil.getLoggedInUsername());
    }

    public static APIConsumer getLoggedInUserConsumer() throws APIManagementException {
        return APIManagerFactory.getInstance().getAPIConsumer(RestApiCommonUtil.getLoggedInUsername());
    }

    public static String getLoggedInUsername() {
        return CarbonContext.getThreadLocalCarbonContext().getUsername();
    }

    public static String getLoggedInUserTenantDomain() {
        return CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
    }

    public static String getRFC3339Date(Date date) {
        DateTimeFormatter jodaDateTimeFormatter = ISODateTimeFormat.dateTime();
        DateTime dateTime = new DateTime((Object)date);
        return jodaDateTimeFormatter.print((ReadableInstant)dateTime);
    }

    public static Map<String, Integer> getPaginationParams(Integer offset, Integer limit, Integer size) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (offset >= size || offset < 0) {
            return result;
        }
        int start = offset;
        int end = offset + limit - 1;
        int nextStart = end + 1;
        if (nextStart < size) {
            result.put("next_offset", nextStart);
            result.put("next_limit", limit);
        }
        int previousEnd = start - 1;
        int previousStart = previousEnd - limit + 1;
        if (previousEnd >= 0) {
            if (previousStart < 0) {
                result.put("previous_offset", 0);
                result.put("previous_limit", limit);
            } else {
                result.put("previous_offset", previousStart);
                result.put("previous_limit", limit);
            }
        }
        return result;
    }

    public static String getAPIPaginatedURL(Integer offset, Integer limit, String query) {
        String paginatedURL = "/apis?limit={limit}&offset={offset}&query={query}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        paginatedURL = paginatedURL.replace("{query}", query);
        return paginatedURL;
    }

    public static String getApplicationPaginatedURL(Integer offset, Integer limit, String groupId) {
        return RestApiCommonUtil.getApplicationPaginatedURLWithSortParams(offset, limit, groupId, null, null);
    }

    public static String getApplicationPaginatedURLWithSortParams(Integer offset, Integer limit, String groupId, String sortOrder, String sortBy) {
        groupId = groupId == null ? "" : groupId;
        String paginatedURL = "/applications?limit={limit}&offset={offset}&groupId={groupId}";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sortBy}) || StringUtils.isNotBlank((CharSequence)sortOrder)) {
            sortOrder = sortOrder == null ? "" : sortOrder;
            sortBy = sortBy == null ? "" : sortBy;
            paginatedURL = "/applications?sortBy={sortBy}&sortOrder={sortOrder}&limit={limit}&offset={offset}&groupId={groupId}";
            paginatedURL = paginatedURL.replace("{sortBy}", sortBy);
            paginatedURL = paginatedURL.replace("{sortOrder}", sortOrder);
        }
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        paginatedURL = paginatedURL.replace("{groupId}", groupId);
        return paginatedURL;
    }

    public static String getApplicationPaginatedURL(Integer offset, Integer limit) {
        String paginatedURL = "/applications?limit={limit}&offset={offset}&groupId={groupId}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        return paginatedURL;
    }

    public static String getSubscriptionPaginatedURLForAPIId(Integer offset, Integer limit, String apiId, String groupId) {
        groupId = groupId == null ? "" : groupId;
        String paginatedURL = "/subscriptions?limit={limit}&offset={offset}&apiId={apiId}&groupId={groupId}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        paginatedURL = paginatedURL.replace("{apiId}", apiId);
        paginatedURL = paginatedURL.replace("{groupId}", groupId);
        return paginatedURL;
    }

    public static String getSubscriptionPaginatedURLForApplicationId(Integer offset, Integer limit, String applicationId) {
        String paginatedURL = "/subscriptions?limit={limit}&offset={offset}&applicationId={applicationId}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        paginatedURL = paginatedURL.replace("{applicationId}", applicationId);
        return paginatedURL;
    }

    public static String getDocumentationPaginatedURL(Integer offset, Integer limit, String apiId) {
        String paginatedURL = "/apis/{apiId}/documents?limit={limit}&offset={offset}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        paginatedURL = paginatedURL.replace("{apiId}", apiId);
        return paginatedURL;
    }

    public static String getRatingPaginatedURL(Integer offset, Integer limit, String apiId) {
        String paginatedURL = "/ratings?limit={limit}&offset={offset}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        paginatedURL = paginatedURL.replace("{apiId}", apiId);
        return paginatedURL;
    }

    public static String getTiersPaginatedURL(String tierLevel, Integer offset, Integer limit) {
        String paginatedURL = "/throttling-policies/{tierLevel}?limit={limit}&offset={offset}";
        paginatedURL = paginatedURL.replace("{tierLevel}", tierLevel);
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        return paginatedURL;
    }

    public static String getTagsPaginatedURL(Integer offset, Integer limit) {
        String paginatedURL = "/tags?limit={limit}&offset={offset}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        return paginatedURL;
    }

    public static String getScopesPaginatedURL(Integer offset, Integer limit) {
        String paginatedURL = "/scopes?limit={limit}&offset={offset}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        return paginatedURL;
    }

    public static String getResourcePathPaginatedURL(Integer offset, Integer limit) {
        String paginatedURL = "/resource-paths?limit={limit}&offset={offset}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        return paginatedURL;
    }

    public static String getAPIProductPaginatedURL(Integer offset, Integer limit, String query) {
        String paginatedURL = "/apis?limit={limit}&offset={offset}&query={query}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        paginatedURL = paginatedURL.replace("{query}", query);
        return paginatedURL;
    }

    public static String getProductDocumentPaginatedURL(Integer offset, Integer limit, String apiId) {
        String paginatedURL = "/api-products/{apiProductId}/documents?limit={limit}&offset={offset}";
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        paginatedURL = paginatedURL.replace("{apiId}", apiId);
        return paginatedURL;
    }

    public static APIProvider getProvider(String username) throws APIManagementException {
        return APIManagerFactory.getInstance().getAPIProvider(username);
    }

    public static boolean isUUID(String apiId) {
        try {
            UUID.fromString(apiId);
            return true;
        }
        catch (IllegalArgumentException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(apiId + " is not a valid UUID"));
            }
            return false;
        }
    }

    public static APIConsumer getConsumer(String subscriberName) throws APIManagementException {
        return APIManagerFactory.getInstance().getAPIConsumer(subscriberName);
    }

    public static String retrieveSwaggerDefinition(API api, APIProvider apiProvider) throws APIManagementException {
        String apiSwagger = null;
        String providerName = APIUtil.replaceEmailDomainBack((String)api.getId().getProviderName());
        String providerTenantDomain = MultitenantUtils.getTenantDomain((String)providerName);
        apiSwagger = api.getUuid() != null ? apiProvider.getOpenAPIDefinition(api.getUuid(), providerTenantDomain) : apiProvider.getOpenAPIDefinition((Identifier)api.getId(), providerTenantDomain);
        APIDefinition parser = OASParserUtil.getOASParser((String)apiSwagger);
        return parser.getOASDefinitionForPublisher(api, apiSwagger);
    }

    public static void validateUserTenantWithAPIIdentifier(APIIdentifier apiIdentifier) throws APIMgtAuthorizationFailedException {
        String loggedInUserTenantDomain;
        String username = RestApiCommonUtil.getLoggedInUsername();
        String providerName = APIUtil.replaceEmailDomainBack((String)apiIdentifier.getProviderName());
        String providerTenantDomain = MultitenantUtils.getTenantDomain((String)providerName);
        if (!providerTenantDomain.equals(loggedInUserTenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain())) {
            String errorMsg = "User " + username + " is not allowed to access " + apiIdentifier.toString() + " as it belongs to a different tenant : " + providerTenantDomain;
            throw new APIMgtAuthorizationFailedException(errorMsg);
        }
    }

    public static boolean isURL(String url) {
        Pattern pattern = Pattern.compile("^(http|https)://(.)+", 2);
        Matcher matcher = pattern.matcher(url);
        return matcher.matches();
    }

    public static String retrieveAsyncAPIDefinition(API api, APIProvider apiProvider) throws APIManagementException {
        return apiProvider.getAsyncAPIDefinition((Identifier)api.getId());
    }

    public static String getValidateTenantDomain(String xWSO2Tenant) {
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        if (xWSO2Tenant == null) {
            return tenantDomain;
        }
        if ("carbon.super".equals(tenantDomain)) {
            return xWSO2Tenant;
        }
        return tenantDomain;
    }
}

