/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.streamdefn.filesystem;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.streamdefn.filesystem.internal.ServiceHolder;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;

public class FileSystemStreamDefinitionStore
extends AbstractStreamDefinitionStore {
    private static final Log log = LogFactory.getLog(FileSystemStreamDefinitionStore.class);

    public StreamDefinition getStreamDefinitionFromStore(String name, String version, int tenantId) throws StreamDefinitionStoreException {
        boolean tenantFlowStarted = false;
        try {
            tenantFlowStarted = this.startTenantFlow(tenantId);
            StreamDefinition streamDefinition = ServiceHolder.getEventStreamService().getStreamDefinition(name, version);
            return streamDefinition;
        }
        catch (EventStreamConfigurationException ex) {
            String msg = "Error while loading the stream definition name: " + name + ", version: " + version;
            log.error((Object)msg, (Throwable)ex);
            throw new StreamDefinitionStoreException(msg, (Throwable)ex);
        }
        finally {
            if (tenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    public StreamDefinition getStreamDefinitionFromStore(String streamId, int tenantId) throws StreamDefinitionStoreException {
        boolean tenantFlowStarted = false;
        try {
            tenantFlowStarted = this.startTenantFlow(tenantId);
            StreamDefinition streamDefinition = ServiceHolder.getEventStreamService().getStreamDefinition(streamId);
            return streamDefinition;
        }
        catch (EventStreamConfigurationException ex) {
            String msg = "Error while loading the stream definition Id: " + streamId;
            log.error((Object)(msg + streamId), (Throwable)ex);
            throw new StreamDefinitionStoreException(msg, (Throwable)ex);
        }
        finally {
            if (tenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    public Collection<StreamDefinition> getAllStreamDefinitionsFromStore(int tenantId) throws StreamDefinitionStoreException {
        boolean tenantFlowStarted = false;
        try {
            tenantFlowStarted = this.startTenantFlow(tenantId);
            List list = ServiceHolder.getEventStreamService().getAllStreamDefinitions();
            return list;
        }
        catch (EventStreamConfigurationException ex) {
            String msg = "Error while loading all stream definitions for tenant: " + tenantId;
            log.error((Object)msg, (Throwable)ex);
            throw new StreamDefinitionStoreException(msg, (Throwable)ex);
        }
        finally {
            if (tenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    public void saveStreamDefinitionToStore(StreamDefinition streamDefinition, int tenantId) throws StreamDefinitionStoreException {
        boolean tenantFlowStarted = false;
        try {
            tenantFlowStarted = this.startTenantFlow(tenantId);
            ServiceHolder.getEventStreamService().addEventStreamDefinition(streamDefinition);
        }
        catch (EventStreamConfigurationException ex) {
            String msg = "Error while saving the stream definition: " + streamDefinition;
            log.error((Object)msg, (Throwable)ex);
            throw new StreamDefinitionStoreException(msg, (Throwable)ex);
        }
        finally {
            if (tenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStreamDefinition(String name, String version, int tenantId) {
        boolean tenantFlowStarted = false;
        try {
            tenantFlowStarted = this.startTenantFlow(tenantId);
            ServiceHolder.getEventStreamService().removeEventStreamDefinition(name, version);
            boolean bl = true;
            return bl;
        }
        catch (EventStreamConfigurationException ex) {
            String msg = "Error while removing the stream definition name :" + name + ", version : " + version;
            log.error((Object)msg, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private boolean startTenantFlow(int tenantId) {
        int currentTenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (currentTenantId == -1 || currentTenantId == -1234 && currentTenantId != tenantId) {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId, true);
            return true;
        }
        return false;
    }
}

