/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.FakeScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortRescorer;

class ExpressionRescorer
extends SortRescorer {
    private final Expression expression;
    private final Bindings bindings;

    public ExpressionRescorer(Expression expression, Bindings bindings) {
        super(new Sort(expression.getSortField(bindings, true)));
        this.expression = expression;
        this.bindings = bindings;
    }

    @Override
    public Explanation explain(IndexSearcher searcher, Explanation firstPassExplanation, int docID) throws IOException {
        Explanation superExpl = super.explain(searcher, firstPassExplanation, docID);
        List<LeafReaderContext> leaves = searcher.getIndexReader().leaves();
        int subReader = ReaderUtil.subIndex(docID, leaves);
        LeafReaderContext readerContext = leaves.get(subReader);
        int docIDInSegment = docID - readerContext.docBase;
        HashMap<String, FakeScorer> context = new HashMap<String, FakeScorer>();
        FakeScorer fakeScorer = new FakeScorer();
        fakeScorer.score = firstPassExplanation.getValue();
        fakeScorer.doc = docIDInSegment;
        context.put("scorer", fakeScorer);
        ArrayList<Explanation> subs = new ArrayList<Explanation>(Arrays.asList(superExpl.getDetails()));
        for (String variable : this.expression.variables) {
            subs.add(Explanation.match((float)this.bindings.getValueSource(variable).getValues(context, readerContext).doubleVal(docIDInSegment), "variable \"" + variable + "\"", new Explanation[0]));
        }
        return Explanation.match(superExpl.getValue(), superExpl.getDescription(), subs);
    }
}

