/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.memory.FSTTermOutputs;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

public class FSTTermsWriter
extends FieldsConsumer {
    static final String TERMS_EXTENSION = "tmp";
    static final String TERMS_CODEC_NAME = "FSTTerms";
    public static final int TERMS_VERSION_START = 2;
    public static final int TERMS_VERSION_CURRENT = 2;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    IndexOutput out;
    final int maxDoc;
    final List<FieldMetaData> fields = new ArrayList<FieldMetaData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSTTermsWriter(SegmentWriteState state, PostingsWriterBase postingsWriter) throws IOException {
        String termsFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, TERMS_EXTENSION);
        this.postingsWriter = postingsWriter;
        this.fieldInfos = state.fieldInfos;
        this.out = state.directory.createOutput(termsFileName, state.context);
        this.maxDoc = state.segmentInfo.maxDoc();
        boolean success = false;
        try {
            CodecUtil.writeIndexHeader(this.out, TERMS_CODEC_NAME, 2, state.segmentInfo.getId(), state.segmentSuffix);
            this.postingsWriter.init(this.out, state);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.out);
            throw throwable;
        }
    }

    private void writeTrailer(IndexOutput out, long dirStart) throws IOException {
        out.writeLong(dirStart);
    }

    @Override
    public void write(Fields fields) throws IOException {
        for (String field : fields) {
            BytesRef term;
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(field);
            boolean hasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            TermsEnum termsEnum = terms.iterator();
            TermsWriter termsWriter = new TermsWriter(fieldInfo);
            long sumTotalTermFreq = 0L;
            long sumDocFreq = 0L;
            FixedBitSet docsSeen = new FixedBitSet(this.maxDoc);
            while ((term = termsEnum.next()) != null) {
                BlockTermState termState = this.postingsWriter.writeTerm(term, termsEnum, docsSeen);
                if (termState == null) continue;
                termsWriter.finishTerm(term, termState);
                sumTotalTermFreq += termState.totalTermFreq;
                sumDocFreq += (long)termState.docFreq;
            }
            termsWriter.finish(hasFreq ? sumTotalTermFreq : -1L, sumDocFreq, docsSeen.cardinality());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block8: {
                block6: {
                    if (this.out == null) break block7;
                    boolean success = false;
                    try {
                        long dirStart = this.out.getFilePointer();
                        this.out.writeVInt(this.fields.size());
                        for (FieldMetaData field : this.fields) {
                            this.out.writeVInt(field.fieldInfo.number);
                            this.out.writeVLong(field.numTerms);
                            if (field.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                                this.out.writeVLong(field.sumTotalTermFreq);
                            }
                            this.out.writeVLong(field.sumDocFreq);
                            this.out.writeVInt(field.docCount);
                            this.out.writeVInt(field.longsSize);
                            field.dict.save(this.out);
                        }
                        this.writeTrailer(this.out, dirStart);
                        CodecUtil.writeFooter(this.out);
                        success = true;
                        if (!success) break block6;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close(this.out, this.postingsWriter);
                        } else {
                            IOUtils.closeWhileHandlingException(this.out, this.postingsWriter);
                        }
                        this.out = null;
                        throw throwable;
                    }
                    IOUtils.close(this.out, this.postingsWriter);
                    break block8;
                }
                IOUtils.closeWhileHandlingException(this.out, this.postingsWriter);
            }
            this.out = null;
        }
    }

    final class TermsWriter {
        private final Builder<FSTTermOutputs.TermData> builder;
        private final FSTTermOutputs outputs;
        private final FieldInfo fieldInfo;
        private final int longsSize;
        private long numTerms = 0L;
        private final IntsRefBuilder scratchTerm = new IntsRefBuilder();
        private final RAMOutputStream metaWriter = new RAMOutputStream();

        TermsWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.longsSize = FSTTermsWriter.this.postingsWriter.setField(fieldInfo);
            this.outputs = new FSTTermOutputs(fieldInfo, this.longsSize);
            this.builder = new Builder<FSTTermOutputs.TermData>(FST.INPUT_TYPE.BYTE1, this.outputs);
        }

        public void finishTerm(BytesRef text, BlockTermState state) throws IOException {
            FSTTermOutputs.TermData meta = new FSTTermOutputs.TermData();
            meta.longs = new long[this.longsSize];
            meta.bytes = null;
            meta.docFreq = state.docFreq;
            meta.totalTermFreq = state.totalTermFreq;
            FSTTermsWriter.this.postingsWriter.encodeTerm(meta.longs, this.metaWriter, this.fieldInfo, state, true);
            int bytesSize = (int)this.metaWriter.getFilePointer();
            if (bytesSize > 0) {
                meta.bytes = new byte[bytesSize];
                this.metaWriter.writeTo(meta.bytes, 0);
                this.metaWriter.reset();
            }
            this.builder.add(Util.toIntsRef(text, this.scratchTerm), meta);
            ++this.numTerms;
        }

        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            if (this.numTerms > 0L) {
                FST<FSTTermOutputs.TermData> fst = this.builder.finish();
                FSTTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, this.numTerms, sumTotalTermFreq, sumDocFreq, docCount, this.longsSize, fst));
            }
        }
    }

    private static class FieldMetaData {
        public final FieldInfo fieldInfo;
        public final long numTerms;
        public final long sumTotalTermFreq;
        public final long sumDocFreq;
        public final int docCount;
        public final int longsSize;
        public final FST<FSTTermOutputs.TermData> dict;

        public FieldMetaData(FieldInfo fieldInfo, long numTerms, long sumTotalTermFreq, long sumDocFreq, int docCount, int longsSize, FST<FSTTermOutputs.TermData> fst) {
            this.fieldInfo = fieldInfo;
            this.numTerms = numTerms;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            this.longsSize = longsSize;
            this.dict = fst;
        }
    }
}

