/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.bloom;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.bloom.HashFunction;
import org.apache.lucene.codecs.bloom.MurmurHash2;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;

public class FuzzySet
implements Accountable {
    public static final int VERSION_SPI = 1;
    public static final int VERSION_START = 1;
    public static final int VERSION_CURRENT = 2;
    private HashFunction hashFunction;
    private FixedBitSet filter;
    private int bloomSize;
    static final int[] usableBitSetSizes;

    public static HashFunction hashFunctionForVersion(int version) {
        if (version < 1) {
            throw new IllegalArgumentException("Version " + version + " is too old, expected at least " + 1);
        }
        if (version > 2) {
            throw new IllegalArgumentException("Version " + version + " is too new, expected at most " + 2);
        }
        return MurmurHash2.INSTANCE;
    }

    public static int getNearestSetSize(int maxNumberOfBits) {
        int result = usableBitSetSizes[0];
        for (int i = 0; i < usableBitSetSizes.length; ++i) {
            if (usableBitSetSizes[i] > maxNumberOfBits) continue;
            result = usableBitSetSizes[i];
        }
        return result;
    }

    public static int getNearestSetSize(int maxNumberOfValuesExpected, float desiredSaturation) {
        for (int i = 0; i < usableBitSetSizes.length; ++i) {
            int numSetBitsAtDesiredSaturation = (int)((float)usableBitSetSizes[i] * desiredSaturation);
            int estimatedNumUniqueValues = FuzzySet.getEstimatedNumberUniqueValuesAllowingForCollisions(usableBitSetSizes[i], numSetBitsAtDesiredSaturation);
            if (estimatedNumUniqueValues <= maxNumberOfValuesExpected) continue;
            return usableBitSetSizes[i];
        }
        return -1;
    }

    public static FuzzySet createSetBasedOnMaxMemory(int maxNumBytes) {
        int setSize = FuzzySet.getNearestSetSize(maxNumBytes);
        return new FuzzySet(new FixedBitSet(setSize + 1), setSize, FuzzySet.hashFunctionForVersion(2));
    }

    public static FuzzySet createSetBasedOnQuality(int maxNumUniqueValues, float desiredMaxSaturation) {
        int setSize = FuzzySet.getNearestSetSize(maxNumUniqueValues, desiredMaxSaturation);
        return new FuzzySet(new FixedBitSet(setSize + 1), setSize, FuzzySet.hashFunctionForVersion(2));
    }

    private FuzzySet(FixedBitSet filter, int bloomSize, HashFunction hashFunction) {
        this.filter = filter;
        this.bloomSize = bloomSize;
        this.hashFunction = hashFunction;
    }

    public ContainsResult contains(BytesRef value) {
        int hash = this.hashFunction.hash(value);
        if (hash < 0) {
            hash *= -1;
        }
        return this.mayContainValue(hash);
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(2);
        out.writeInt(this.bloomSize);
        long[] bits = this.filter.getBits();
        out.writeInt(bits.length);
        for (int i = 0; i < bits.length; ++i) {
            out.writeLong(bits[i]);
        }
    }

    public static FuzzySet deserialize(DataInput in) throws IOException {
        int version = in.readInt();
        if (version == 1) {
            in.readString();
        }
        HashFunction hashFunction = FuzzySet.hashFunctionForVersion(version);
        int bloomSize = in.readInt();
        int numLongs = in.readInt();
        long[] longs = new long[numLongs];
        for (int i = 0; i < numLongs; ++i) {
            longs[i] = in.readLong();
        }
        FixedBitSet bits = new FixedBitSet(longs, bloomSize + 1);
        return new FuzzySet(bits, bloomSize, hashFunction);
    }

    private ContainsResult mayContainValue(int positiveHash) {
        assert (positiveHash >= 0);
        int pos = positiveHash & this.bloomSize;
        if (this.filter.get(pos)) {
            return ContainsResult.MAYBE;
        }
        return ContainsResult.NO;
    }

    public void addValue(BytesRef value) throws IOException {
        int hash = this.hashFunction.hash(value);
        if (hash < 0) {
            hash *= -1;
        }
        int bloomPos = hash & this.bloomSize;
        this.filter.set(bloomPos);
    }

    public FuzzySet downsize(float targetMaxSaturation) {
        int numBitsSet = this.filter.cardinality();
        FixedBitSet rightSizedBitSet = this.filter;
        int rightSizedBitSetSize = this.bloomSize;
        for (int i = 0; i < usableBitSetSizes.length; ++i) {
            int candidateBitsetSize = usableBitSetSizes[i];
            float candidateSaturation = (float)numBitsSet / (float)candidateBitsetSize;
            if (!(candidateSaturation <= targetMaxSaturation)) continue;
            rightSizedBitSetSize = candidateBitsetSize;
            break;
        }
        if (rightSizedBitSetSize < this.bloomSize) {
            rightSizedBitSet = new FixedBitSet(rightSizedBitSetSize + 1);
            int bitIndex = 0;
            do {
                if ((bitIndex = this.filter.nextSetBit(bitIndex)) == Integer.MAX_VALUE) continue;
                int downSizedBitIndex = bitIndex & rightSizedBitSetSize;
                rightSizedBitSet.set(downSizedBitIndex);
                ++bitIndex;
            } while (bitIndex >= 0 && bitIndex <= this.bloomSize);
        } else {
            return null;
        }
        return new FuzzySet(rightSizedBitSet, rightSizedBitSetSize, this.hashFunction);
    }

    public int getEstimatedUniqueValues() {
        return FuzzySet.getEstimatedNumberUniqueValuesAllowingForCollisions(this.bloomSize, this.filter.cardinality());
    }

    public static int getEstimatedNumberUniqueValuesAllowingForCollisions(int setSize, int numRecordedBits) {
        double setSizeAsDouble = setSize;
        double numRecordedBitsAsDouble = numRecordedBits;
        double saturation = numRecordedBitsAsDouble / setSizeAsDouble;
        double logInverseSaturation = Math.log(1.0 - saturation) * -1.0;
        return (int)(setSizeAsDouble * logInverseSaturation);
    }

    public float getSaturation() {
        int numBitsSet = this.filter.cardinality();
        return (float)numBitsSet / (float)this.bloomSize;
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this.filter.getBits());
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(hash=" + this.hashFunction + ")";
    }

    static {
        int mask;
        usableBitSetSizes = new int[30];
        int size = mask = 1;
        for (int i = 0; i < usableBitSetSizes.length; ++i) {
            FuzzySet.usableBitSetSizes[i] = size = size << 1 | mask;
        }
    }

    public static enum ContainsResult {
        MAYBE,
        NO;

    }
}

