/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;

public class FixedGapTermsIndexReader
extends TermsIndexReaderBase {
    private final long indexInterval;
    private final int packedIntsVersion;
    private final int blocksize;
    private static final int PAGED_BYTES_BITS = 15;
    private final PagedBytes.Reader termBytesReader;
    final HashMap<String, FieldIndexData> fields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedGapTermsIndexReader(SegmentReadState state) throws IOException {
        PagedBytes termBytes;
        block10: {
            IndexInput in;
            block9: {
                this.fields = new HashMap();
                termBytes = new PagedBytes(15);
                String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "tii");
                in = state.directory.openInput(fileName, state.context);
                boolean success = false;
                try {
                    CodecUtil.checkIndexHeader(in, "FixedGapTermsIndex", 4, 4, state.segmentInfo.getId(), state.segmentSuffix);
                    CodecUtil.checksumEntireFile(in);
                    this.indexInterval = in.readVInt();
                    if (this.indexInterval < 1L) {
                        throw new CorruptIndexException("invalid indexInterval: " + this.indexInterval, in);
                    }
                    this.packedIntsVersion = in.readVInt();
                    this.blocksize = in.readVInt();
                    this.seekDir(in);
                    int numFields = in.readVInt();
                    if (numFields < 0) {
                        throw new CorruptIndexException("invalid numFields: " + numFields, in);
                    }
                    for (int i = 0; i < numFields; ++i) {
                        int field = in.readVInt();
                        long numIndexTerms = in.readVInt();
                        if (numIndexTerms < 0L) {
                            throw new CorruptIndexException("invalid numIndexTerms: " + numIndexTerms, in);
                        }
                        long termsStart = in.readVLong();
                        long indexStart = in.readVLong();
                        long packedIndexStart = in.readVLong();
                        long packedOffsetsStart = in.readVLong();
                        if (packedIndexStart < indexStart) {
                            throw new CorruptIndexException("invalid packedIndexStart: " + packedIndexStart + " indexStart: " + indexStart + "numIndexTerms: " + numIndexTerms, in);
                        }
                        FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                        FieldIndexData previous = this.fields.put(fieldInfo.name, new FieldIndexData(in, termBytes, indexStart, termsStart, packedIndexStart, packedOffsetsStart, numIndexTerms));
                        if (previous == null) continue;
                        throw new CorruptIndexException("duplicate field: " + fieldInfo.name, in);
                    }
                    success = true;
                    if (!success) break block9;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in);
                    } else {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    this.termBytesReader = termBytes.freeze(true);
                    throw throwable;
                }
                IOUtils.close(in);
                break block10;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        this.termBytesReader = termBytes.freeze(true);
    }

    @Override
    public boolean supportsOrd() {
        return true;
    }

    @Override
    public TermsIndexReaderBase.FieldIndexEnum getFieldEnum(FieldInfo fieldInfo) {
        return new IndexEnum(this.fields.get(fieldInfo.name));
    }

    @Override
    public void close() throws IOException {
    }

    private void seekDir(IndexInput input) throws IOException {
        input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
        long dirOffset = input.readLong();
        input.seek(dirOffset);
    }

    @Override
    public long ramBytesUsed() {
        long sizeInBytes = this.termBytesReader != null ? this.termBytesReader.ramBytesUsed() : 0L;
        for (FieldIndexData entry : this.fields.values()) {
            sizeInBytes += entry.ramBytesUsed();
        }
        return sizeInBytes;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables("field", this.fields);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fields.size() + ",interval=" + this.indexInterval + ")";
    }

    private final class FieldIndexData
    implements Accountable {
        final long termBytesStart;
        final MonotonicBlockPackedReader termOffsets;
        final MonotonicBlockPackedReader termsDictOffsets;
        final long numIndexTerms;
        final long termsStart;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FieldIndexData(IndexInput in, PagedBytes termBytes, long indexStart, long termsStart, long packedIndexStart, long packedOffsetsStart, long numIndexTerms) throws IOException {
            this.termsStart = termsStart;
            this.termBytesStart = termBytes.getPointer();
            IndexInput clone = in.clone();
            clone.seek(indexStart);
            this.numIndexTerms = numIndexTerms;
            assert (this.numIndexTerms > 0L) : "numIndexTerms=" + numIndexTerms;
            try {
                long numTermBytes = packedIndexStart - indexStart;
                termBytes.copy(clone, numTermBytes);
                this.termsDictOffsets = MonotonicBlockPackedReader.of(clone, FixedGapTermsIndexReader.this.packedIntsVersion, FixedGapTermsIndexReader.this.blocksize, numIndexTerms, false);
                this.termOffsets = MonotonicBlockPackedReader.of(clone, FixedGapTermsIndexReader.this.packedIntsVersion, FixedGapTermsIndexReader.this.blocksize, 1L + numIndexTerms, false);
            }
            finally {
                clone.close();
            }
        }

        @Override
        public long ramBytesUsed() {
            return (this.termOffsets != null ? this.termOffsets.ramBytesUsed() : 0L) + (this.termsDictOffsets != null ? this.termsDictOffsets.ramBytesUsed() : 0L);
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            if (this.termOffsets != null) {
                resources.add(Accountables.namedAccountable("term lengths", this.termOffsets));
            }
            if (this.termsDictOffsets != null) {
                resources.add(Accountables.namedAccountable("offsets", this.termsDictOffsets));
            }
            return Collections.unmodifiableList(resources);
        }

        public String toString() {
            return "FixedGapTermIndex(indexterms=" + this.numIndexTerms + ")";
        }
    }

    private class IndexEnum
    extends TermsIndexReaderBase.FieldIndexEnum {
        private final FieldIndexData fieldIndex;
        private final BytesRef term = new BytesRef();
        private long ord;

        public IndexEnum(FieldIndexData fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        @Override
        public BytesRef term() {
            return this.term;
        }

        @Override
        public long seek(BytesRef target) {
            long lo = 0L;
            long hi = this.fieldIndex.numIndexTerms - 1L;
            while (hi >= lo) {
                long mid = lo + hi >>> 1;
                long offset = this.fieldIndex.termOffsets.get(mid);
                int length = (int)(this.fieldIndex.termOffsets.get(1L + mid) - offset);
                FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
                int delta = target.compareTo(this.term);
                if (delta < 0) {
                    hi = mid - 1L;
                    continue;
                }
                if (delta > 0) {
                    lo = mid + 1L;
                    continue;
                }
                assert (mid >= 0L);
                this.ord = mid * FixedGapTermsIndexReader.this.indexInterval;
                return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(mid);
            }
            if (hi < 0L) {
                assert (hi == -1L);
                hi = 0L;
            }
            long offset = this.fieldIndex.termOffsets.get(hi);
            int length = (int)(this.fieldIndex.termOffsets.get(1L + hi) - offset);
            FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
            this.ord = hi * FixedGapTermsIndexReader.this.indexInterval;
            return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(hi);
        }

        @Override
        public long next() {
            long idx = 1L + this.ord / FixedGapTermsIndexReader.this.indexInterval;
            if (idx >= this.fieldIndex.numIndexTerms) {
                return -1L;
            }
            this.ord += FixedGapTermsIndexReader.this.indexInterval;
            long offset = this.fieldIndex.termOffsets.get(idx);
            int length = (int)(this.fieldIndex.termOffsets.get(1L + idx) - offset);
            FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
            return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(idx);
        }

        @Override
        public long ord() {
            return this.ord;
        }

        @Override
        public long seek(long ord) {
            long idx = ord / FixedGapTermsIndexReader.this.indexInterval;
            assert (idx < this.fieldIndex.numIndexTerms);
            long offset = this.fieldIndex.termOffsets.get(idx);
            int length = (int)(this.fieldIndex.termOffsets.get(1L + idx) - offset);
            FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
            this.ord = idx * FixedGapTermsIndexReader.this.indexInterval;
            return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(idx);
        }
    }
}

