/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.autoprefix;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsReader;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.IOUtils;

public final class AutoPrefixPostingsFormat
extends PostingsFormat {
    private final int minItemsInBlock;
    private final int maxItemsInBlock;
    private final int minItemsInAutoPrefix;
    private final int maxItemsInAutoPrefix;

    public AutoPrefixPostingsFormat() {
        this(25, 48, 25, 48);
    }

    public AutoPrefixPostingsFormat(int minItemsInAutoPrefix, int maxItemsInAutoPrefix) {
        this(25, 48, minItemsInAutoPrefix, maxItemsInAutoPrefix);
    }

    public AutoPrefixPostingsFormat(int minItemsInBlock, int maxItemsInBlock, int minItemsInAutoPrefix, int maxItemsInAutoPrefix) {
        super("AutoPrefix");
        BlockTreeTermsWriter.validateSettings(minItemsInBlock, maxItemsInBlock);
        BlockTreeTermsWriter.validateAutoPrefixSettings(minItemsInAutoPrefix, maxItemsInAutoPrefix);
        this.minItemsInBlock = minItemsInBlock;
        this.maxItemsInBlock = maxItemsInBlock;
        this.minItemsInAutoPrefix = minItemsInAutoPrefix;
        this.maxItemsInAutoPrefix = maxItemsInAutoPrefix;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        BlockTreeTermsWriter blockTreeTermsWriter;
        block3: {
            Lucene50PostingsWriter postingsWriter = new Lucene50PostingsWriter(state);
            boolean success = false;
            try {
                BlockTreeTermsWriter ret = new BlockTreeTermsWriter(state, postingsWriter, this.minItemsInBlock, this.maxItemsInBlock, this.minItemsInAutoPrefix, this.maxItemsInAutoPrefix);
                success = true;
                blockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return blockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        BlockTreeTermsReader blockTreeTermsReader;
        block3: {
            Lucene50PostingsReader postingsReader = new Lucene50PostingsReader(state);
            boolean success = false;
            try {
                BlockTreeTermsReader ret = new BlockTreeTermsReader(postingsReader, state);
                success = true;
                blockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return blockTreeTermsReader;
    }
}

