/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.tokenattributes;

import org.apache.lucene.analysis.ja.Token;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.ja.util.ToStringUtil;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class ReadingAttributeImpl
extends AttributeImpl
implements ReadingAttribute,
Cloneable {
    private Token token;

    @Override
    public String getReading() {
        return this.token == null ? null : this.token.getReading();
    }

    @Override
    public String getPronunciation() {
        return this.token == null ? null : this.token.getPronunciation();
    }

    @Override
    public void setToken(Token token) {
        this.token = token;
    }

    @Override
    public void clear() {
        this.token = null;
    }

    @Override
    public void copyTo(AttributeImpl target) {
        ReadingAttribute t = (ReadingAttribute)((Object)target);
        t.setToken(this.token);
    }

    @Override
    public void reflectWith(AttributeReflector reflector) {
        String reading = this.getReading();
        String readingEN = reading == null ? null : ToStringUtil.getRomanization(reading);
        String pronunciation = this.getPronunciation();
        String pronunciationEN = pronunciation == null ? null : ToStringUtil.getRomanization(pronunciation);
        reflector.reflect(ReadingAttribute.class, "reading", reading);
        reflector.reflect(ReadingAttribute.class, "reading (en)", readingEN);
        reflector.reflect(ReadingAttribute.class, "pronunciation", pronunciation);
        reflector.reflect(ReadingAttribute.class, "pronunciation (en)", pronunciationEN);
    }
}

