/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.tokenattributes;

import org.apache.lucene.analysis.ja.Token;
import org.apache.lucene.analysis.ja.tokenattributes.InflectionAttribute;
import org.apache.lucene.analysis.ja.util.ToStringUtil;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class InflectionAttributeImpl
extends AttributeImpl
implements InflectionAttribute,
Cloneable {
    private Token token;

    @Override
    public String getInflectionType() {
        return this.token == null ? null : this.token.getInflectionType();
    }

    @Override
    public String getInflectionForm() {
        return this.token == null ? null : this.token.getInflectionForm();
    }

    @Override
    public void setToken(Token token) {
        this.token = token;
    }

    @Override
    public void clear() {
        this.token = null;
    }

    @Override
    public void copyTo(AttributeImpl target) {
        InflectionAttribute t = (InflectionAttribute)((Object)target);
        t.setToken(this.token);
    }

    @Override
    public void reflectWith(AttributeReflector reflector) {
        String type = this.getInflectionType();
        String typeEN = type == null ? null : ToStringUtil.getInflectionTypeTranslation(type);
        reflector.reflect(InflectionAttribute.class, "inflectionType", type);
        reflector.reflect(InflectionAttribute.class, "inflectionType (en)", typeEN);
        String form = this.getInflectionForm();
        String formEN = form == null ? null : ToStringUtil.getInflectedFormTranslation(form);
        reflector.reflect(InflectionAttribute.class, "inflectionForm", form);
        reflector.reflect(InflectionAttribute.class, "inflectionForm (en)", formEN);
    }
}

