/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttle.policy.deployer.utils;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.log.CommonsLogLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.wso2.carbon.apimgt.api.model.policy.Condition;
import org.wso2.carbon.apimgt.api.model.policy.HeaderCondition;
import org.wso2.carbon.apimgt.api.model.policy.IPCondition;
import org.wso2.carbon.apimgt.api.model.policy.JWTClaimsCondition;
import org.wso2.carbon.apimgt.api.model.policy.QueryParameterCondition;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.template.APITemplateException;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.APIPolicyConditionGroup;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApiPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApplicationPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.GlobalPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.SubscriptionPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.throttle.policy.deployer.utils.PolicyMappingUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class ThrottlePolicyTemplateBuilder {
    private static final Log log = LogFactory.getLog(ThrottlePolicyTemplateBuilder.class);
    private static final String POLICY_VELOCITY_RESOURCE = "throttle_policy_template_resource";
    private static final String POLICY_VELOCITY_RESOURCE_DEFAULT = "throttle_policy_template_resource_default";
    private static final String POLICY_VELOCITY_GLOBAL = "throttle_policy_template_global";
    private static final String POLICY_VELOCITY_APP = "throttle_policy_template_app";
    private static final String POLICY_VELOCITY_SUB = "throttle_policy_template_sub";
    private static final String POLICY_VELOCITY_ASYNC_SUB = "throttle_policy_template_async_sub";
    private static String velocityLogPath = "not-defined";
    private final String policyTemplateLocation = "repository" + File.separator + "resources" + File.separator + "policy_templates" + File.separator;

    private static String getVelocityLogger() {
        APIManagerConfiguration config;
        String logPath;
        if ("not-defined".equalsIgnoreCase(velocityLogPath) && (logPath = (config = ServiceReferenceHolder.getInstance().getAPIMConfiguration()).getFirstProperty("VelocityLogger")) != null && !logPath.isEmpty()) {
            velocityLogPath = logPath;
        }
        return velocityLogPath;
    }

    private static String getPolicyCondition(Set<org.wso2.carbon.apimgt.throttle.policy.deployer.dto.Condition> conditions) {
        StringBuilder conditionString = new StringBuilder();
        int i = 0;
        for (org.wso2.carbon.apimgt.throttle.policy.deployer.dto.Condition condition : conditions) {
            Condition mappedCondition = PolicyMappingUtil.mapCondition(condition);
            if (i == 0) {
                conditionString.append(mappedCondition.getCondition());
            } else {
                conditionString.append(" AND ").append(mappedCondition.getCondition());
            }
            ++i;
        }
        return conditionString.toString();
    }

    private static JSONObject getPolicyConditionJson(Set<org.wso2.carbon.apimgt.throttle.policy.deployer.dto.Condition> conditions) {
        JSONObject tempCondition = new JSONObject();
        for (org.wso2.carbon.apimgt.throttle.policy.deployer.dto.Condition condition : conditions) {
            JSONObject values;
            Condition mappedCondition = PolicyMappingUtil.mapCondition(condition);
            JSONObject conditionJson = tempCondition.containsKey((Object)mappedCondition.getType().toLowerCase(Locale.ENGLISH)) ? (JSONObject)tempCondition.get((Object)mappedCondition.getType().toLowerCase(Locale.ENGLISH)) : new JSONObject();
            tempCondition.put((Object)mappedCondition.getType().toLowerCase(Locale.ENGLISH), (Object)conditionJson);
            if ("IPSpecific".equals(mappedCondition.getType())) {
                IPCondition ipCondition = (IPCondition)mappedCondition;
                if (IPCondition.isIPv6Address((String)ipCondition.getSpecificIP())) {
                    conditionJson.put((Object)"specificIp", (Object)String.valueOf(APIUtil.ipToBigInteger((String)ipCondition.getSpecificIP())));
                } else {
                    conditionJson.put((Object)"specificIp", (Object)ipCondition.ipToLong(ipCondition.getSpecificIP()));
                }
            } else if ("IPRange".equals(mappedCondition.getType())) {
                IPCondition ipRangeCondition = (IPCondition)mappedCondition;
                if (IPCondition.isIPv6Address((String)ipRangeCondition.getStartingIP()) && IPCondition.isIPv6Address((String)ipRangeCondition.getEndingIP())) {
                    conditionJson.put((Object)"startingIp", (Object)String.valueOf(APIUtil.ipToBigInteger((String)ipRangeCondition.getStartingIP())));
                    conditionJson.put((Object)"endingIp", (Object)String.valueOf(APIUtil.ipToBigInteger((String)ipRangeCondition.getEndingIP())));
                } else {
                    conditionJson.put((Object)"startingIp", (Object)ipRangeCondition.ipToLong(ipRangeCondition.getStartingIP()));
                    conditionJson.put((Object)"endingIp", (Object)ipRangeCondition.ipToLong(ipRangeCondition.getEndingIP()));
                }
            } else if (mappedCondition instanceof QueryParameterCondition) {
                QueryParameterCondition queryParameterCondition = (QueryParameterCondition)mappedCondition;
                if (conditionJson.containsKey((Object)"values")) {
                    values = (JSONObject)conditionJson.get((Object)"values");
                } else {
                    values = new JSONObject();
                    conditionJson.put((Object)"values", (Object)values);
                }
                values.put((Object)queryParameterCondition.getParameter(), (Object)queryParameterCondition.getValue());
            } else if (mappedCondition instanceof HeaderCondition) {
                HeaderCondition headerCondition = (HeaderCondition)mappedCondition;
                if (conditionJson.containsKey((Object)"values")) {
                    values = (JSONObject)conditionJson.get((Object)"values");
                } else {
                    values = new JSONObject();
                    conditionJson.put((Object)"values", (Object)values);
                }
                values.put((Object)headerCondition.getHeaderName(), (Object)headerCondition.getValue());
            } else if (mappedCondition instanceof JWTClaimsCondition) {
                JWTClaimsCondition jwtClaimsCondition = (JWTClaimsCondition)mappedCondition;
                if (conditionJson.containsKey((Object)"values")) {
                    values = (JSONObject)conditionJson.get((Object)"values");
                } else {
                    values = new JSONObject();
                    conditionJson.put((Object)"values", (Object)values);
                }
                values.put((Object)jwtClaimsCondition.getClaimUrl(), (Object)jwtClaimsCondition.getAttribute());
            }
            conditionJson.put((Object)"invert", (Object)mappedCondition.isInvertCondition());
        }
        return tempCondition;
    }

    private static String getPolicyConditionForDefault(Set<org.wso2.carbon.apimgt.throttle.policy.deployer.dto.Condition> conditions) {
        StringBuilder conditionString = new StringBuilder();
        int i = 0;
        for (org.wso2.carbon.apimgt.throttle.policy.deployer.dto.Condition condition : conditions) {
            Condition mappedCondition = PolicyMappingUtil.mapCondition(condition);
            String conditionStringComplete = mappedCondition.getCondition();
            if (i == 0) {
                conditionString.append(conditionStringComplete);
            } else {
                conditionString.append(" AND ").append(conditionStringComplete);
            }
            ++i;
        }
        return conditionString.toString();
    }

    private static String getConditionForDefault(Set<String> conditionsSet) {
        StringBuilder conditionString = new StringBuilder();
        int i = 0;
        for (String condition : conditionsSet) {
            String conditionIsolated = "(" + condition + ")";
            if (i == 0) {
                conditionString = new StringBuilder(conditionIsolated);
            } else {
                conditionString.append(" OR ").append(conditionIsolated);
            }
            ++i;
        }
        if (!StringUtils.isEmpty((CharSequence)conditionString.toString())) {
            conditionString = new StringBuilder("NOT(" + conditionString + ")");
        }
        return conditionString.toString();
    }

    private static void setConstantContext(VelocityContext context) {
        context.put("ACROSS_ALL", (Object)"apiLevel");
        context.put("PER_USER", (Object)"userLevel");
        context.put("POLICY_LEVEL_API", (Object)"api");
        context.put("POLICY_LEVEL_APP", (Object)"app");
        context.put("POLICY_LEVEL_SUB", (Object)"sub");
        context.put("POLICY_LEVEL_GLOBAL", (Object)"global");
        context.put("REQUEST_COUNT_TYPE", (Object)"requestCount");
        context.put("BANDWIDTH_TYPE", (Object)"bandwidthVolume");
    }

    public Map<String, String> getThrottlePolicyForAPILevel(ApiPolicy policy) throws APITemplateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating policy for API Level :" + policy.toString()));
        }
        HashMap<String, String> policyArray = new HashMap<String, String>();
        try {
            VelocityEngine velocityengine = new VelocityEngine();
            velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
            if (!"not-defined".equalsIgnoreCase(ThrottlePolicyTemplateBuilder.getVelocityLogger())) {
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.setProperty("file.resource.loader.path", (Object)CarbonUtils.getCarbonHome());
            velocityengine.init();
            Template template = velocityengine.getTemplate(this.getTemplatePathForAPI());
            if (policy.getConditionGroups() != null) {
                for (APIPolicyConditionGroup conditionGroup : policy.getConditionGroups()) {
                    if (conditionGroup.getDefaultLimit() == null) continue;
                    VelocityContext context = new VelocityContext();
                    ThrottlePolicyTemplateBuilder.setConstantContext(context);
                    context.put("policy", (Object)policy);
                    context.put("quotaPolicy", (Object)conditionGroup.getDefaultLimit());
                    context.put("pipeline", (Object)("condition_" + conditionGroup.getConditionGroupId()));
                    String conditionString = ThrottlePolicyTemplateBuilder.getPolicyCondition(conditionGroup.getCondition());
                    JSONArray conditions = new JSONArray();
                    conditions.add((Object)ThrottlePolicyTemplateBuilder.getPolicyConditionJson(conditionGroup.getCondition()));
                    context.put("condition", (Object)(" AND " + conditionString));
                    context.put("evaluatedConditions", (Object)new String(Base64.encodeBase64((byte[])conditions.toJSONString().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
                    StringWriter writer = new StringWriter();
                    template.merge((Context)context, (Writer)writer);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Policy : " + writer.toString()));
                    }
                    String policyName = policy.getTenantDomain() + "_" + "resource" + "_" + policy.getName() + "_condition_" + conditionGroup.getConditionGroupId();
                    policyArray.put(policyName, writer.toString());
                }
            }
        }
        catch (VelocityException e) {
            log.error((Object)"Velocity Error", (Throwable)e);
            throw new APITemplateException("Velocity Error", (Throwable)e);
        }
        return policyArray;
    }

    public String getThrottlePolicyForAPILevelDefault(ApiPolicy policy) throws APITemplateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating default policy for API Level :" + policy.toString()));
        }
        HashSet<String> conditionsSet = new HashSet<String>();
        try {
            VelocityEngine velocityengine = new VelocityEngine();
            velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
            if (!"not-defined".equalsIgnoreCase(ThrottlePolicyTemplateBuilder.getVelocityLogger())) {
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.setProperty("file.resource.loader.path", (Object)CarbonUtils.getCarbonHome());
            velocityengine.init();
            Template template = velocityengine.getTemplate(this.getTemplatePathForAPIDefaultPolicy());
            List<APIPolicyConditionGroup> conditionGroups = policy.getConditionGroups();
            JSONArray policyConditionJson = new JSONArray();
            if (conditionGroups != null) {
                for (APIPolicyConditionGroup conditionGroup : conditionGroups) {
                    if (conditionGroup.getDefaultLimit() == null) continue;
                    policyConditionJson.add((Object)ThrottlePolicyTemplateBuilder.getPolicyConditionJson(conditionGroup.getCondition()));
                    String conditionString = ThrottlePolicyTemplateBuilder.getPolicyConditionForDefault(conditionGroup.getCondition());
                    if (StringUtils.isEmpty((CharSequence)conditionString)) continue;
                    conditionsSet.add(conditionString);
                }
            }
            VelocityContext context = new VelocityContext();
            ThrottlePolicyTemplateBuilder.setConstantContext(context);
            context.put("policy", (Object)policy);
            context.put("quotaPolicy", (Object)policy.getDefaultLimit());
            context.put("evaluatedConditions", (Object)new String(Base64.encodeBase64((byte[])policyConditionJson.toJSONString().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
            String conditionSetString = ThrottlePolicyTemplateBuilder.getConditionForDefault(conditionsSet);
            if (!StringUtils.isEmpty((CharSequence)conditionSetString)) {
                context.put("condition", (Object)(" AND " + conditionSetString));
            } else {
                context.put("condition", (Object)"");
            }
            StringWriter writer = new StringWriter();
            template.merge((Context)context, (Writer)writer);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Policy : " + writer.toString()));
            }
            return writer.toString();
        }
        catch (VelocityException e) {
            log.error((Object)"Velocity Error", (Throwable)e);
            throw new APITemplateException("Velocity Error", (Throwable)e);
        }
    }

    public String getThrottlePolicyForGlobalLevel(GlobalPolicy policy) throws APITemplateException {
        StringWriter writer = new StringWriter();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating policy for global level :" + policy.toString()));
        }
        try {
            VelocityEngine velocityengine = new VelocityEngine();
            velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
            if (!"not-defined".equalsIgnoreCase(ThrottlePolicyTemplateBuilder.getVelocityLogger())) {
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.setProperty("file.resource.loader.path", (Object)CarbonUtils.getCarbonHome());
            velocityengine.init();
            Template template = velocityengine.getTemplate(this.getTemplatePathForGlobal());
            VelocityContext context = new VelocityContext();
            ThrottlePolicyTemplateBuilder.setConstantContext(context);
            context.put("policy", (Object)policy);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Policy : " + writer.toString()));
            }
            template.merge((Context)context, (Writer)writer);
        }
        catch (VelocityException e) {
            log.error((Object)"Velocity Error", (Throwable)e);
            throw new APITemplateException("Velocity Error", (Throwable)e);
        }
        return writer.toString();
    }

    public String getThrottlePolicyForAppLevel(ApplicationPolicy policy) throws APITemplateException {
        StringWriter writer = new StringWriter();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating policy for app level :" + policy.toString()));
        }
        try {
            VelocityEngine velocityengine = new VelocityEngine();
            velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
            if (!"not-defined".equalsIgnoreCase(ThrottlePolicyTemplateBuilder.getVelocityLogger())) {
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.setProperty("file.resource.loader.path", (Object)CarbonUtils.getCarbonHome());
            velocityengine.init();
            Template template = velocityengine.getTemplate(this.getTemplatePathForApplication());
            VelocityContext context = new VelocityContext();
            ThrottlePolicyTemplateBuilder.setConstantContext(context);
            context.put("policy", (Object)policy);
            context.put("quotaPolicy", (Object)policy.getDefaultLimit());
            template.merge((Context)context, (Writer)writer);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Policy : " + writer.toString()));
            }
        }
        catch (VelocityException e) {
            log.error((Object)"Velocity Error", (Throwable)e);
            throw new APITemplateException("Velocity Error", (Throwable)e);
        }
        return writer.toString();
    }

    public String getThrottlePolicyForSubscriptionLevel(SubscriptionPolicy policy) throws APITemplateException {
        StringWriter writer = new StringWriter();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating policy for subscription Level :" + policy.toString()));
        }
        try {
            VelocityEngine velocityengine = new VelocityEngine();
            velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
            if (!"not-defined".equalsIgnoreCase(ThrottlePolicyTemplateBuilder.getVelocityLogger())) {
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.setProperty("file.resource.loader.path", (Object)CarbonUtils.getCarbonHome());
            velocityengine.init();
            Template template = "eventCount".equals(policy.getDefaultLimit().getQuotaType()) ? velocityengine.getTemplate(this.getTemplatePathForAsyncSubscription()) : velocityengine.getTemplate(this.getTemplatePathForSubscription());
            VelocityContext context = new VelocityContext();
            ThrottlePolicyTemplateBuilder.setConstantContext(context);
            context.put("policy", (Object)policy);
            context.put("quotaPolicy", (Object)policy.getDefaultLimit());
            template.merge((Context)context, (Writer)writer);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Policy : " + writer.toString()));
            }
        }
        catch (VelocityException e) {
            log.error((Object)"Velocity Error", (Throwable)e);
            throw new APITemplateException("Velocity Error", (Throwable)e);
        }
        return writer.toString();
    }

    private String getTemplatePathForAPI() {
        return this.policyTemplateLocation + POLICY_VELOCITY_RESOURCE + ".xml";
    }

    private String getTemplatePathForAPIDefaultPolicy() {
        return this.policyTemplateLocation + POLICY_VELOCITY_RESOURCE_DEFAULT + ".xml";
    }

    private String getTemplatePathForGlobal() {
        return this.policyTemplateLocation + POLICY_VELOCITY_GLOBAL + ".xml";
    }

    private String getTemplatePathForApplication() {
        return this.policyTemplateLocation + POLICY_VELOCITY_APP + ".xml";
    }

    private String getTemplatePathForSubscription() {
        return this.policyTemplateLocation + POLICY_VELOCITY_SUB + ".xml";
    }

    private String getTemplatePathForAsyncSubscription() {
        return this.policyTemplateLocation + POLICY_VELOCITY_ASYNC_SUB + ".xml";
    }
}

