/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttle.policy.deployer.utils;

import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.jms.JMSTransportHandler;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.throttle.policy.deployer.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.throttle.policy.deployer.utils.PolicyUtil;
import org.wso2.carbon.apimgt.throttle.policy.deployer.utils.ThrottlePolicyJMSMessageListener;
import org.wso2.carbon.core.ServerShutdownHandler;
import org.wso2.carbon.core.ServerStartupObserver;

public class ThrottlePolicyStartupListener
implements ServerStartupObserver,
ServerShutdownHandler,
Runnable {
    private final Log log = LogFactory.getLog(ThrottlePolicyStartupListener.class);
    private JMSTransportHandler jmsTransportHandlerForEventHub;

    public ThrottlePolicyStartupListener() {
        EventHubConfigurationDto.EventHubReceiverConfiguration eventHubReceiverConfiguration = ServiceReferenceHolder.getInstance().getAPIMConfiguration().getEventHubConfigurationDto().getEventHubReceiverConfiguration();
        if (eventHubReceiverConfiguration != null) {
            this.jmsTransportHandlerForEventHub = new JMSTransportHandler(eventHubReceiverConfiguration.getJmsConnectionParameters());
        }
    }

    public void completingServerStartup() {
    }

    public void completedServerStartup() {
        this.deployPoliciesInAsyncMode();
        this.jmsTransportHandlerForEventHub.subscribeForJmsEvents("notification", (MessageListener)new ThrottlePolicyJMSMessageListener());
    }

    public void invoke() {
        if (this.jmsTransportHandlerForEventHub != null) {
            this.log.debug((Object)"Unsubscribe from JMS Events...");
            this.jmsTransportHandlerForEventHub.unSubscribeFromEvents();
        }
    }

    @Override
    public void run() {
        PolicyUtil.deployAllPolicies();
    }

    private void deployPoliciesInAsyncMode() {
        new Thread(this).start();
    }
}

