/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttle.policy.deployer.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.notifier.events.APIPolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.ApplicationPolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.GlobalPolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.PolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.SubscriptionPolicyEvent;
import org.wso2.carbon.apimgt.throttle.policy.deployer.PolicyRetriever;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApiPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApplicationPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.GlobalPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.SubscriptionPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.exception.ThrottlePolicyDeployerException;
import org.wso2.carbon.apimgt.throttle.policy.deployer.utils.PolicyRetrieverThreadFactory;
import org.wso2.carbon.apimgt.throttle.policy.deployer.utils.PolicyUtil;

public class ThrottlePolicyJMSMessageListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(ThrottlePolicyJMSMessageListener.class);
    private final PolicyRetriever policyRetriever = new PolicyRetriever();
    private final ScheduledExecutorService policyRetrievalScheduler = Executors.newScheduledThreadPool(10, new PolicyRetrieverThreadFactory());

    public void onMessage(Message message) {
        try {
            if (message != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event received in JMS Event Receiver - " + message));
                }
                Topic jmsDestination = (Topic)message.getJMSDestination();
                if (message instanceof TextMessage) {
                    String textMessage = ((TextMessage)message).getText();
                    JsonNode payloadData = new ObjectMapper().readTree(textMessage).path("event").path("payloadData");
                    if ("notification".equalsIgnoreCase(jmsDestination.getTopicName()) && payloadData.get("eventType").asText() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Event received from the topic of " + jmsDestination.getTopicName()));
                        }
                        this.handleNotificationMessage(payloadData.get("eventType").asText(), payloadData.get("event").asText());
                    }
                } else {
                    log.warn((Object)("Event dropped due to unsupported message type " + message.getClass()));
                }
            } else {
                log.warn((Object)"Dropping the empty/null event received through jms receiver");
            }
        }
        catch (JsonProcessingException | JMSException e) {
            log.error((Object)"JMSException occurred when processing the received message ", e);
        }
    }

    private void handleNotificationMessage(String eventType, String encodedEvent) {
        byte[] eventDecoded = Base64.decodeBase64((String)encodedEvent);
        String eventJson = new String(eventDecoded, StandardCharsets.UTF_8);
        if (APIConstants.EventType.POLICY_CREATE.toString().equals(eventType) || APIConstants.EventType.POLICY_UPDATE.toString().equals(eventType) || APIConstants.EventType.POLICY_DELETE.toString().equals(eventType)) {
            boolean updatePolicy = APIConstants.EventType.POLICY_CREATE.toString().equals(eventType) || APIConstants.EventType.POLICY_UPDATE.toString().equals(eventType);
            boolean deletePolicy = APIConstants.EventType.POLICY_DELETE.toString().equals(eventType);
            Runnable task = null;
            PolicyEvent event = (PolicyEvent)new Gson().fromJson(eventJson, PolicyEvent.class);
            if (event.getPolicyType() == APIConstants.PolicyType.SUBSCRIPTION) {
                SubscriptionPolicyEvent policyEvent = (SubscriptionPolicyEvent)new Gson().fromJson(eventJson, SubscriptionPolicyEvent.class);
                if (!("Unlimited".equalsIgnoreCase(policyEvent.getPolicyName()) || "AsyncUnlimited".equalsIgnoreCase(policyEvent.getPolicyName()) || "AsyncWHUnlimited".equalsIgnoreCase(policyEvent.getPolicyName()))) {
                    task = () -> {
                        try {
                            if (updatePolicy) {
                                SubscriptionPolicy subscriptionPolicy = this.policyRetriever.getSubscriptionPolicy(policyEvent.getPolicyName(), policyEvent.getTenantDomain());
                                PolicyUtil.deployPolicy(subscriptionPolicy, (PolicyEvent)policyEvent);
                            } else if (deletePolicy) {
                                PolicyUtil.undeployPolicy(policyEvent);
                            }
                        }
                        catch (ThrottlePolicyDeployerException e) {
                            log.error((Object)"Error in retrieving subscription policy metadata from the database", (Throwable)e);
                        }
                    };
                }
            } else if (event.getPolicyType() == APIConstants.PolicyType.APPLICATION) {
                ApplicationPolicyEvent policyEvent = (ApplicationPolicyEvent)new Gson().fromJson(eventJson, ApplicationPolicyEvent.class);
                if (!"Unlimited".equalsIgnoreCase(policyEvent.getPolicyName())) {
                    task = () -> {
                        try {
                            if (updatePolicy) {
                                ApplicationPolicy applicationPolicy = this.policyRetriever.getApplicationPolicy(policyEvent.getPolicyName(), policyEvent.getTenantDomain());
                                PolicyUtil.deployPolicy(applicationPolicy, (PolicyEvent)policyEvent);
                            } else if (deletePolicy) {
                                PolicyUtil.undeployPolicy(policyEvent);
                            }
                        }
                        catch (ThrottlePolicyDeployerException e) {
                            log.error((Object)"Error in retrieving application policy metadata from the database", (Throwable)e);
                        }
                    };
                }
            } else if (event.getPolicyType() == APIConstants.PolicyType.API) {
                APIPolicyEvent policyEvent = (APIPolicyEvent)new Gson().fromJson(eventJson, APIPolicyEvent.class);
                if (!"Unlimited".equalsIgnoreCase(policyEvent.getPolicyName())) {
                    task = () -> {
                        try {
                            if (updatePolicy) {
                                ApiPolicy apiPolicy = this.policyRetriever.getApiPolicy(policyEvent.getPolicyName(), policyEvent.getTenantDomain());
                                PolicyUtil.deployPolicy(apiPolicy, (PolicyEvent)policyEvent);
                            } else if (deletePolicy) {
                                PolicyUtil.undeployPolicy(policyEvent);
                            }
                        }
                        catch (ThrottlePolicyDeployerException e) {
                            log.error((Object)"Error in retrieving API policy metadata from the database", (Throwable)e);
                        }
                    };
                }
            } else if (event.getPolicyType() == APIConstants.PolicyType.GLOBAL) {
                GlobalPolicyEvent policyEvent = (GlobalPolicyEvent)new Gson().fromJson(eventJson, GlobalPolicyEvent.class);
                task = () -> {
                    try {
                        if (updatePolicy) {
                            GlobalPolicy globalPolicy = this.policyRetriever.getGlobalPolicy(policyEvent.getPolicyName(), policyEvent.getTenantDomain());
                            PolicyUtil.deployPolicy(globalPolicy, (PolicyEvent)policyEvent);
                        } else if (deletePolicy) {
                            PolicyUtil.undeployPolicy(policyEvent);
                        }
                    }
                    catch (ThrottlePolicyDeployerException e) {
                        log.error((Object)"Error in retrieving Global policy metadata from the database", (Throwable)e);
                    }
                };
            }
            if (task != null) {
                this.policyRetrievalScheduler.schedule(task, 1L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

