/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttle.policy.deployer.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.notifier.events.APIPolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.ApplicationPolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.GlobalPolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.PolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.SubscriptionPolicyEvent;
import org.wso2.carbon.apimgt.impl.template.APITemplateException;
import org.wso2.carbon.apimgt.throttle.policy.deployer.PolicyRetriever;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApiPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApiPolicyList;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApplicationPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApplicationPolicyList;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.GlobalPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.GlobalPolicyList;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.Policy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.SubscriptionPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.SubscriptionPolicyList;
import org.wso2.carbon.apimgt.throttle.policy.deployer.exception.ThrottlePolicyDeployerException;
import org.wso2.carbon.apimgt.throttle.policy.deployer.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.throttle.policy.deployer.utils.ThrottlePolicyTemplateBuilder;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.processor.core.EventProcessorService;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanConfigurationException;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanDependencyValidationException;

public class PolicyUtil {
    private static final Log log = LogFactory.getLog(PolicyUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployPolicy(Policy policy, PolicyEvent policyEvent) {
        EventProcessorService eventProcessorService = ServiceReferenceHolder.getInstance().getEventProcessorService();
        ThrottlePolicyTemplateBuilder policyTemplateBuilder = new ThrottlePolicyTemplateBuilder();
        Map<Object, Object> policiesToDeploy = new HashMap();
        ArrayList<String> policiesToUndeploy = new ArrayList<String>();
        try {
            String policyString;
            String policyFile;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            if (Policy.PolicyType.SUBSCRIPTION.equals((Object)policy.getType()) && policy instanceof SubscriptionPolicy) {
                policyFile = String.join((CharSequence)"_", policy.getTenantDomain(), "sub", policy.getName());
                policyString = policyTemplateBuilder.getThrottlePolicyForSubscriptionLevel((SubscriptionPolicy)policy);
                policiesToDeploy.put(policyFile, policyString);
            } else if (Policy.PolicyType.APPLICATION.equals((Object)policy.getType()) && policy instanceof ApplicationPolicy) {
                policyFile = String.join((CharSequence)"_", policy.getTenantDomain(), "app", policy.getName());
                policyString = policyTemplateBuilder.getThrottlePolicyForAppLevel((ApplicationPolicy)policy);
                policiesToDeploy.put(policyFile, policyString);
            } else if (Policy.PolicyType.API.equals((Object)policy.getType()) && policy instanceof ApiPolicy) {
                List deletedConditionGroupIds;
                policiesToDeploy = policyTemplateBuilder.getThrottlePolicyForAPILevel((ApiPolicy)policy);
                String defaultPolicy = policyTemplateBuilder.getThrottlePolicyForAPILevelDefault((ApiPolicy)policy);
                policyFile = String.join((CharSequence)"_", policy.getTenantDomain(), "resource", policy.getName());
                String defaultPolicyName = policyFile + "_default";
                policiesToDeploy.put(defaultPolicyName, defaultPolicy);
                if (policyEvent instanceof APIPolicyEvent && (deletedConditionGroupIds = ((APIPolicyEvent)policyEvent).getDeletedConditionGroupIds()) != null) {
                    Iterator iterator = deletedConditionGroupIds.iterator();
                    while (iterator.hasNext()) {
                        int conditionGroupId = (Integer)iterator.next();
                        policiesToUndeploy.add(policyFile + "_condition_" + conditionGroupId);
                    }
                }
            } else if (Policy.PolicyType.GLOBAL.equals((Object)policy.getType()) && policy instanceof GlobalPolicy) {
                GlobalPolicy globalPolicy = (GlobalPolicy)policy;
                policyFile = String.join((CharSequence)"_", "global", policy.getName());
                policyString = policyTemplateBuilder.getThrottlePolicyForGlobalLevel(globalPolicy);
                policiesToDeploy.put(policyFile, policyString);
            }
            PolicyUtil.undeployPolicies(policiesToUndeploy);
            for (Map.Entry<Object, Object> pair : policiesToDeploy.entrySet()) {
                String policyPlanName = (String)pair.getKey();
                String flowString = (String)pair.getValue();
                String executionPlan = null;
                try {
                    executionPlan = eventProcessorService.getActiveExecutionPlan(policyPlanName);
                }
                catch (ExecutionPlanConfigurationException e) {
                    eventProcessorService.deployExecutionPlan(flowString);
                }
                if (executionPlan == null) continue;
                eventProcessorService.editActiveExecutionPlan(flowString, policyPlanName);
            }
        }
        catch (APITemplateException e) {
            log.error((Object)"Error in creating execution plan", (Throwable)e);
        }
        catch (ExecutionPlanConfigurationException | ExecutionPlanDependencyValidationException e) {
            log.error((Object)"Error in deploying execution plan", e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static void deployAllPolicies() {
        PolicyUtil.undeployAllPolicies();
        PolicyRetriever policyRetriever = new PolicyRetriever();
        try {
            SubscriptionPolicyList subscriptionPolicies = policyRetriever.getAllSubscriptionPolicies();
            for (SubscriptionPolicy subscriptionPolicy : subscriptionPolicies.getList()) {
                if ("Unlimited".equalsIgnoreCase(subscriptionPolicy.getName()) || "AsyncUnlimited".equalsIgnoreCase(subscriptionPolicy.getName()) || "AsyncWHUnlimited".equalsIgnoreCase(subscriptionPolicy.getName())) continue;
                PolicyUtil.deployPolicy(subscriptionPolicy, null);
            }
            ApplicationPolicyList applicationPolicies = policyRetriever.getAllApplicationPolicies();
            for (ApplicationPolicy applicationPolicy : applicationPolicies.getList()) {
                if ("Unlimited".equalsIgnoreCase(applicationPolicy.getName())) continue;
                PolicyUtil.deployPolicy(applicationPolicy, null);
            }
            ApiPolicyList apiPolicyList = policyRetriever.getAllApiPolicies();
            for (ApiPolicy apiPolicy : apiPolicyList.getList()) {
                if ("Unlimited".equalsIgnoreCase(apiPolicy.getName())) continue;
                PolicyUtil.deployPolicy(apiPolicy, null);
            }
            GlobalPolicyList globalPolicyList = policyRetriever.getAllGlobalPolicies();
            for (GlobalPolicy globalPolicy : globalPolicyList.getList()) {
                PolicyUtil.deployPolicy(globalPolicy, null);
            }
        }
        catch (ThrottlePolicyDeployerException e) {
            log.error((Object)"Error in retrieving throttle policies", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void undeployAllPolicies() {
        APIManagerConfiguration apiManagerConfiguration = ServiceReferenceHolder.getInstance().getAPIMConfiguration();
        EventProcessorService eventProcessorService = ServiceReferenceHolder.getInstance().getEventProcessorService();
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            Map executionPlanConfigurationMap = eventProcessorService.getAllActiveExecutionConfigurations();
            for (Map.Entry pair : executionPlanConfigurationMap.entrySet()) {
                String policyPlanName = (String)pair.getKey();
                boolean skiped = false;
                for (String skipPolicyName : apiManagerConfiguration.getThrottleProperties().getSkipRedeployingPolicies()) {
                    if (!skipPolicyName.equalsIgnoreCase(policyPlanName)) continue;
                    skiped = true;
                    break;
                }
                if (skiped) continue;
                eventProcessorService.undeployActiveExecutionPlan(policyPlanName);
            }
        }
        catch (ExecutionPlanConfigurationException e) {
            log.error((Object)"Error in removing existing throttle policies", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static void undeployPolicy(SubscriptionPolicyEvent policyEvent) {
        ArrayList<String> policyFileNames = new ArrayList<String>();
        String policyFile = policyEvent.getTenantDomain() + "_" + "sub" + "_" + policyEvent.getPolicyName();
        policyFileNames.add(policyFile);
        PolicyUtil.undeployPolicies(policyFileNames);
    }

    public static void undeployPolicy(ApplicationPolicyEvent policyEvent) {
        ArrayList<String> policyFileNames = new ArrayList<String>();
        String policyFile = policyEvent.getTenantDomain() + "_" + "app" + "_" + policyEvent.getPolicyName();
        policyFileNames.add(policyFile);
        PolicyUtil.undeployPolicies(policyFileNames);
    }

    public static void undeployPolicy(APIPolicyEvent policyEvent) {
        ArrayList<String> policyFileNames = new ArrayList<String>();
        String policyFile = policyEvent.getTenantDomain() + "_" + "resource" + "_" + policyEvent.getPolicyName();
        policyFileNames.add(policyFile + "_default");
        Iterator iterator = policyEvent.getDeletedConditionGroupIds().iterator();
        while (iterator.hasNext()) {
            int conditionGroupId = (Integer)iterator.next();
            policyFileNames.add(policyFile + "_condition_" + conditionGroupId);
        }
        PolicyUtil.undeployPolicies(policyFileNames);
    }

    public static void undeployPolicy(GlobalPolicyEvent policyEvent) {
        ArrayList<String> policyFileNames = new ArrayList<String>();
        String policyFile = "global_" + policyEvent.getPolicyName();
        policyFileNames.add(policyFile);
        PolicyUtil.undeployPolicies(policyFileNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void undeployPolicies(List<String> policyFileNames) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
            EventProcessorService eventProcessorService = ServiceReferenceHolder.getInstance().getEventProcessorService();
            for (String policyFileName : policyFileNames) {
                String executionPlan = null;
                try {
                    executionPlan = eventProcessorService.getActiveExecutionPlan(policyFileName);
                }
                catch (ExecutionPlanConfigurationException executionPlanConfigurationException) {
                    // empty catch block
                }
                if (executionPlan == null) continue;
                eventProcessorService.undeployActiveExecutionPlan(policyFileName);
            }
        }
        catch (ExecutionPlanConfigurationException e) {
            log.error((Object)"Error in removing execution plan", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

