/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttle.policy.deployer.utils;

import org.wso2.carbon.apimgt.api.model.policy.Condition;
import org.wso2.carbon.apimgt.api.model.policy.HeaderCondition;
import org.wso2.carbon.apimgt.api.model.policy.IPCondition;
import org.wso2.carbon.apimgt.api.model.policy.JWTClaimsCondition;
import org.wso2.carbon.apimgt.api.model.policy.QueryParameterCondition;

public class PolicyMappingUtil {
    public static Condition mapCondition(org.wso2.carbon.apimgt.throttle.policy.deployer.dto.Condition conditionDTO) {
        switch (conditionDTO.getConditionType()) {
            case "IPRange": {
                IPCondition ipRangeCondition = new IPCondition("IPRange");
                ipRangeCondition.setInvertCondition(conditionDTO.isInverted());
                ipRangeCondition.setStartingIP(conditionDTO.getName());
                ipRangeCondition.setEndingIP(conditionDTO.getValue());
                return ipRangeCondition;
            }
            case "IPSpecific": {
                IPCondition ipSpecificCondition = new IPCondition("IPSpecific");
                ipSpecificCondition.setInvertCondition(conditionDTO.isInverted());
                ipSpecificCondition.setSpecificIP(conditionDTO.getValue());
                return ipSpecificCondition;
            }
            case "Header": {
                HeaderCondition headerCondition = new HeaderCondition();
                headerCondition.setInvertCondition(conditionDTO.isInverted());
                headerCondition.setHeader(conditionDTO.getName());
                headerCondition.setValue(conditionDTO.getValue());
                return headerCondition;
            }
            case "JWTClaims": {
                JWTClaimsCondition jwtClaimsCondition = new JWTClaimsCondition();
                jwtClaimsCondition.setInvertCondition(conditionDTO.isInverted());
                jwtClaimsCondition.setClaimUrl(conditionDTO.getName());
                jwtClaimsCondition.setAttribute(conditionDTO.getValue());
                return jwtClaimsCondition;
            }
            case "QueryParameterType": {
                QueryParameterCondition queryParameterCondition = new QueryParameterCondition();
                queryParameterCondition.setInvertCondition(conditionDTO.isInverted());
                queryParameterCondition.setParameter(conditionDTO.getName());
                queryParameterCondition.setValue(conditionDTO.getValue());
                return queryParameterCondition;
            }
        }
        return null;
    }
}

