/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttle.policy.deployer.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.impl.dto.ThrottleProperties;
import org.wso2.carbon.apimgt.throttle.policy.deployer.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.throttle.policy.deployer.utils.ThrottlePolicyStartupListener;
import org.wso2.carbon.core.ServerShutdownHandler;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.event.processor.core.EventProcessorService;

@Component(name="org.wso2.apimgt.throttle.policy.deployer", immediate=true)
public class ThrottlePolicyDeployerComponent {
    private static final Log log = LogFactory.getLog(ThrottlePolicyDeployerComponent.class);
    private ServiceRegistration registration;

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"Activating component...");
        APIManagerConfiguration configuration = ServiceReferenceHolder.getInstance().getAPIMConfiguration();
        if (configuration == null) {
            log.warn((Object)"API Manager Configuration not properly set.");
            return;
        }
        ThrottleProperties throttleProperties = configuration.getThrottleProperties();
        if (throttleProperties.isEnablePolicyDeployment()) {
            ThrottlePolicyStartupListener throttlePolicyStartupListener = new ThrottlePolicyStartupListener();
            this.registration = context.getBundleContext().registerService(ServerStartupObserver.class, (Object)throttlePolicyStartupListener, null);
            this.registration = context.getBundleContext().registerService(ServerShutdownHandler.class, (Object)throttlePolicyStartupListener, null);
        }
    }

    @Reference(name="api.manager.config.service", service=APIManagerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAPIManagerConfigurationService")
    protected void setAPIManagerConfigurationService(APIManagerConfigurationService configurationService) {
        log.debug((Object)"Setting APIM Configuration Service");
        ServiceReferenceHolder.getInstance().setAPIMConfigurationService(configurationService);
    }

    protected void unsetAPIManagerConfigurationService(APIManagerConfigurationService configurationService) {
        log.debug((Object)"Unsetting APIM Configuration Service");
        ServiceReferenceHolder.getInstance().setAPIMConfigurationService(null);
    }

    @Reference(name="event.processor.service", service=EventProcessorService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventProcessorService")
    protected void setEventProcessorService(EventProcessorService eventProcessorService) {
        log.debug((Object)"Setting EventProcessor Service");
        ServiceReferenceHolder.getInstance().setEventProcessorService(eventProcessorService);
    }

    protected void unsetEventProcessorService(EventProcessorService eventProcessorService) {
        log.debug((Object)"Unsetting EventProcessor Service");
        ServiceReferenceHolder.getInstance().setEventProcessorService(null);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivating component");
        }
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

