/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttle.policy.deployer;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApiPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApiPolicyList;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApplicationPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.ApplicationPolicyList;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.GlobalPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.GlobalPolicyList;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.SubscriptionPolicy;
import org.wso2.carbon.apimgt.throttle.policy.deployer.dto.SubscriptionPolicyList;
import org.wso2.carbon.apimgt.throttle.policy.deployer.exception.ThrottlePolicyDeployerException;

public class PolicyRetriever {
    private static final Log log = LogFactory.getLog(PolicyRetriever.class);
    protected EventHubConfigurationDto eventHubConfigurationDto = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getEventHubConfigurationDto();
    private final String baseURL = this.eventHubConfigurationDto.getServiceUrl() + "/internal/data/v1";

    public SubscriptionPolicy getSubscriptionPolicy(String policyName, String tenantDomain) throws ThrottlePolicyDeployerException {
        String path = "/subscription-policies?policyName=" + policyName;
        SubscriptionPolicyList subscriptionPolicyList = this.getPolicies(path, tenantDomain, SubscriptionPolicyList.class);
        if (subscriptionPolicyList.getList() != null && !subscriptionPolicyList.getList().isEmpty()) {
            return subscriptionPolicyList.getList().get(0);
        }
        return null;
    }

    public SubscriptionPolicyList getAllSubscriptionPolicies() throws ThrottlePolicyDeployerException {
        String path = "/subscription-policies";
        return this.getPolicies(path, "*", SubscriptionPolicyList.class);
    }

    public ApplicationPolicy getApplicationPolicy(String policyName, String tenantDomain) throws ThrottlePolicyDeployerException {
        String path = "/application-policies?policyName=" + policyName;
        ApplicationPolicyList applicationPolicyList = this.getPolicies(path, tenantDomain, ApplicationPolicyList.class);
        if (applicationPolicyList.getList() != null && !applicationPolicyList.getList().isEmpty()) {
            return applicationPolicyList.getList().get(0);
        }
        return null;
    }

    public ApplicationPolicyList getAllApplicationPolicies() throws ThrottlePolicyDeployerException {
        String path = "/application-policies";
        return this.getPolicies(path, "*", ApplicationPolicyList.class);
    }

    public ApiPolicy getApiPolicy(String policyName, String tenantDomain) throws ThrottlePolicyDeployerException {
        String path = "/api-policies?policyName=" + policyName;
        ApiPolicyList apiPolicyList = this.getPolicies(path, tenantDomain, ApiPolicyList.class);
        if (apiPolicyList.getList() != null && !apiPolicyList.getList().isEmpty()) {
            return apiPolicyList.getList().get(0);
        }
        return null;
    }

    public ApiPolicyList getAllApiPolicies() throws ThrottlePolicyDeployerException {
        String path = "/api-policies";
        return this.getPolicies(path, "*", ApiPolicyList.class);
    }

    public GlobalPolicyList getAllGlobalPolicies() throws ThrottlePolicyDeployerException {
        String path = "/global-policies";
        return this.getPolicies(path, "*", GlobalPolicyList.class);
    }

    public GlobalPolicy getGlobalPolicy(String policyName, String tenantDomain) throws ThrottlePolicyDeployerException {
        String path = "/global-policies?policyName=" + policyName;
        GlobalPolicyList globalPolicyList = this.getPolicies(path, tenantDomain, GlobalPolicyList.class);
        if (globalPolicyList.getList() != null && !globalPolicyList.getList().isEmpty()) {
            return globalPolicyList.getList().get(0);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getPolicies(String path, String tenantDomain, Class<T> policyClass) throws ThrottlePolicyDeployerException {
        String endpoint = this.baseURL + path;
        try (CloseableHttpResponse httpResponse = this.invokeService(endpoint, tenantDomain);){
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String errorMessage = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                throw new ThrottlePolicyDeployerException(errorMessage + "Event-Hub status code is : " + httpResponse.getStatusLine().getStatusCode());
            }
            if (httpResponse.getEntity() == null) throw new ThrottlePolicyDeployerException("HTTP response is empty");
            String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response: " + responseString));
            }
            if (responseString == null) return null;
            if (responseString.isEmpty()) return null;
            Object object = new Gson().fromJson(responseString, policyClass);
            return (T)object;
        }
        catch (IOException e) {
            String msg = "Error while executing the http client";
            log.error((Object)msg, (Throwable)e);
            throw new ThrottlePolicyDeployerException(msg, e);
        }
    }

    private CloseableHttpResponse invokeService(String endpoint, String tenantDomain) throws IOException, ThrottlePolicyDeployerException {
        HttpGet method = new HttpGet(endpoint);
        URL url = new URL(endpoint);
        String username = this.eventHubConfigurationDto.getUsername();
        String password = this.eventHubConfigurationDto.getPassword();
        byte[] credentials = Base64.encodeBase64((byte[])(username + ":" + password).getBytes("UTF-8"));
        int port = url.getPort();
        String protocol = url.getProtocol();
        method.setHeader("xWSO2Tenant", tenantDomain);
        method.setHeader("Authorization", "Basic " + new String(credentials, "UTF-8"));
        HttpClient httpClient = APIUtil.getHttpClient((int)port, (String)protocol);
        try {
            return APIUtil.executeHTTPRequest((HttpRequestBase)method, (HttpClient)httpClient);
        }
        catch (APIManagementException e) {
            throw new ThrottlePolicyDeployerException(e);
        }
    }
}

