/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.authentication.audit;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationResult;
import org.wso2.carbon.identity.data.publisher.authentication.audit.AuthenticationAuditLoggerUtils;
import org.wso2.carbon.identity.data.publisher.authentication.audit.model.AuthenticationAuditData;
import org.wso2.carbon.identity.event.IdentityEventConstants;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;

public class AuthenticationAuditLoggingHandler
extends AbstractEventHandler {
    private static final Log AUDIT_LOG = CarbonConstants.AUDIT_LOG;
    private static final Log LOG = LogFactory.getLog(AuthenticationAuditLoggingHandler.class);
    public static final String USER_AGENT_QUERY_KEY = "User-Agent";
    public static final String USER_AGENT_KEY = "User Agent";
    public static final String REMOTE_ADDRESS_QUERY_KEY = "remoteAddress";
    public static final String REMOTE_ADDRESS_KEY = "RemoteAddress";
    public static final String USER_STORE_DOMAIN_KEY = "UserStoreDomain";

    public String getName() {
        return "authenticationAuditLogger";
    }

    public void handleEvent(Event event) throws IdentityEventException {
        boolean isEnabled = this.isAuthenticationAuditLoggingEnabled(event);
        if (!isEnabled) {
            return;
        }
        AuthenticationAuditData authenticationAuditData = null;
        if (IdentityEventConstants.EventName.AUTHENTICATION_STEP_SUCCESS.name().equals(event.getEventName())) {
            authenticationAuditData = AuthenticationAuditLoggerUtils.createAuthenticationAudiDataObject(event, "audtStep");
            this.doPublishAuthenticationStepSuccess(authenticationAuditData);
        } else if (IdentityEventConstants.EventName.AUTHENTICATION_STEP_FAILURE.name().equals(event.getEventName())) {
            authenticationAuditData = AuthenticationAuditLoggerUtils.createAuthenticationAudiDataObject(event, "audtStep");
            this.doPublishAuthenticationStepFailure(authenticationAuditData);
        } else if (IdentityEventConstants.EventName.AUTHENTICATION_SUCCESS.name().equals(event.getEventName())) {
            authenticationAuditData = AuthenticationAuditLoggerUtils.createAuthenticationAudiDataObject(event, "auditAuth");
            this.doPublishAuthenticationSuccess(authenticationAuditData);
        } else if (IdentityEventConstants.EventName.AUTHENTICATION_FAILURE.name().equals(event.getEventName())) {
            authenticationAuditData = AuthenticationAuditLoggerUtils.createAuthenticationAudiDataObject(event, "auditAuth");
            this.doPublishAuthenticationFailure(authenticationAuditData);
        } else if (IdentityEventConstants.EventName.SESSION_TERMINATE.name().equals(event.getEventName())) {
            this.publishSessionTermination(event);
        } else {
            LOG.error((Object)("Event " + event.getEventName() + " cannot be handled"));
        }
    }

    protected void doPublishAuthenticationStepSuccess(AuthenticationAuditData authenticationData) {
        String auditData = "\"ContextIdentifier\" : \"" + authenticationData.getContextIdentifier() + "\",\"AuthenticatedUser\" : \"" + authenticationData.getAuthenticatedUser() + "\",\"AuthenticatedUserTenantDomain\" : \"" + authenticationData.getTenantDomain() + "\",\"ServiceProviderName\" : \"" + authenticationData.getServiceProvider() + "\",\"RequestType\" : \"" + authenticationData.getInboundProtocol() + "\",\"RelyingParty\" : \"" + authenticationData.getRelyingParty() + "\",\"AuthenticatedIdP\" : \"" + authenticationData.getAuthenticatedIdps() + "\"";
        auditData = this.addContextualInfo(auditData, authenticationData);
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", authenticationData.getAuthenticatedUser(), "LoginStepSuccess", "ApplicationAuthenticationFramework", auditData, "Success"));
    }

    protected void doPublishAuthenticationStepFailure(AuthenticationAuditData authenticationData) {
        String auditData = "\"ContextIdentifier\" : \"" + authenticationData.getContextIdentifier() + "\",\"ServiceProviderName\" : \"" + authenticationData.getServiceProvider() + "\",\"RequestType\" : \"" + authenticationData.getInboundProtocol() + "\",\"RelyingParty\" : \"" + authenticationData.getRelyingParty() + "\",\"StepNo\" : \"" + authenticationData.getStepNo() + "\"";
        auditData = this.addContextualInfo(auditData, authenticationData);
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", authenticationData.getAuthenticatedUser(), "Login", "ApplicationAuthenticationFramework", auditData, "Failed"));
    }

    protected void doPublishAuthenticationSuccess(AuthenticationAuditData authenticationData) {
        AuthenticationResult authenticationResult = new AuthenticationResult();
        authenticationResult.setAuthenticated(true);
        String auditData = "\"ContextIdentifier\" : \"" + authenticationData.getContextIdentifier() + "\",\"AuthenticatedUser\" : \"" + authenticationData.getAuthenticatedUser() + "\",\"AuthenticatedUserTenantDomain\" : \"" + authenticationData.getTenantDomain() + "\",\"ServiceProviderName\" : \"" + authenticationData.getServiceProvider() + "\",\"RequestType\" : \"" + authenticationData.getInboundProtocol() + "\",\"RelyingParty\" : \"" + authenticationData.getRelyingParty() + "\",\"AuthenticatedIdPs\" : \"" + authenticationData.getAuthenticatedIdps() + "\"";
        auditData = this.addContextualInfo(auditData, authenticationData);
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", authenticationData.getAuthenticatedUser(), "Login", "ApplicationAuthenticationFramework", auditData, "Success"));
    }

    protected void doPublishAuthenticationFailure(AuthenticationAuditData authenticationData) {
        String auditData = "\"ContextIdentifier\" : \"" + authenticationData.getContextIdentifier() + "\",\"ServiceProviderName\" : \"" + authenticationData.getServiceProvider() + "\",\"RequestType\" : \"" + authenticationData.getInboundProtocol() + "\",\"RelyingParty\" : \"" + authenticationData.getRelyingParty() + "\",\"StepNo\" : \"" + authenticationData.getStepNo() + "\"";
        auditData = this.addContextualInfo(auditData, authenticationData);
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", authenticationData.getAuthenticatedUser(), "Login", "ApplicationAuthenticationFramework", auditData, "Failed"));
    }

    protected void doPublishSessionTermination(AuthenticationContext context, String username, String tenantDomain, String authenticatedIDPs) {
        String auditData = "\"ContextIdentifier\" : \"" + context.getContextIdentifier() + "\",\"LoggedOutUser\" : \"" + username + "\",\"LoggedOutUserTenantDomain\" : \"" + tenantDomain + "\",\"ServiceProviderName\" : \"" + context.getServiceProviderName() + "\",\"RequestType\" : \"" + context.getRequestType() + "\",\"RelyingParty\" : \"" + context.getRelyingParty() + "\",\"AuthenticatedIdPs\" : \"" + authenticatedIDPs + "\"";
        String idpName = null;
        ExternalIdPConfig externalIdPConfig = context.getExternalIdP();
        if (externalIdPConfig != null) {
            idpName = externalIdPConfig.getName();
        }
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", username, "Logout", idpName, auditData, "Success"));
    }

    protected void publishSessionTermination(Event event) {
        Map properties = event.getEventProperties();
        SessionContext sessionContext = (SessionContext)properties.get("sessionContext");
        AuthenticationContext context = (AuthenticationContext)properties.get("context");
        if (context == null) {
            return;
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        AuthenticatedUser authenticatedUser = null;
        String username = "";
        String tenantDomain = "";
        String authenticatedIDPs = "";
        if (sequenceConfig != null && sequenceConfig.getAuthenticatedUser() != null) {
            authenticatedUser = sequenceConfig.getAuthenticatedUser();
            authenticatedIDPs = sequenceConfig.getAuthenticatedIdPs();
        } else {
            Object authenticatedUserObj = sessionContext.getProperty("AuthenticatedUser");
            if (authenticatedUserObj != null) {
                authenticatedUser = (AuthenticatedUser)authenticatedUserObj;
            }
        }
        if (authenticatedUser != null) {
            username = authenticatedUser.getAuthenticatedSubjectIdentifier();
            tenantDomain = authenticatedUser.getTenantDomain();
        }
        this.doPublishSessionTermination(context, username, tenantDomain, authenticatedIDPs);
    }

    private boolean isAuthenticationAuditLoggingEnabled(Event event) throws IdentityEventException {
        if (this.configs.getModuleProperties() != null) {
            String handlerEnabled = this.configs.getModuleProperties().getProperty("authenticationAuditLogger.enable");
            return Boolean.parseBoolean(handlerEnabled);
        }
        return false;
    }

    private String addContextualInfo(String data, AuthenticationAuditData authenticationData) {
        data = data + ",\"User Agent\" : \"" + MDC.get((String)USER_AGENT_QUERY_KEY) + "\",\"" + REMOTE_ADDRESS_KEY + "\" : \"" + MDC.get((String)REMOTE_ADDRESS_QUERY_KEY) + "\",\"" + USER_STORE_DOMAIN_KEY + "\" : \"" + authenticationData.getUserStoreDomain() + "\"";
        return data;
    }
}

