/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.authentication.audit;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorStatus;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.data.publisher.authentication.audit.model.AuthenticationAuditData;
import org.wso2.carbon.identity.event.event.Event;

public class AuthenticationAuditLoggerUtils {
    public static AuthenticationAuditData createAuthenticationAudiDataObject(Event event, String authType) {
        Map properties = event.getEventProperties();
        AuthenticationContext context = AuthenticationAuditLoggerUtils.getAuthenticationContextFromProperties(properties);
        Map<String, Object> params = AuthenticationAuditLoggerUtils.getParamsFromProperties(properties);
        AuthenticatorStatus status = AuthenticationAuditLoggerUtils.getAuthenticatorStatusFromProperties(properties);
        AuthenticationAuditData authenticationAuditData = new AuthenticationAuditData();
        authenticationAuditData.setContextIdentifier(AuthenticationAuditLoggerUtils.getContextIdentifier(context));
        authenticationAuditData.setServiceProvider(AuthenticationAuditLoggerUtils.getServiceProvider(context));
        authenticationAuditData.setInboundProtocol(AuthenticationAuditLoggerUtils.getInboundProtocol(context));
        authenticationAuditData.setRelyingParty(AuthenticationAuditLoggerUtils.getRelyingParty(context));
        Object userObj = params.get("user");
        AuthenticationAuditLoggerUtils.setUserStoreDomain(authenticationAuditData, userObj);
        if ("audtStep".equals(authType)) {
            authenticationAuditData.setAuthenticatedUser(AuthenticationAuditLoggerUtils.getUserNameForAuthenticationStep(params));
            authenticationAuditData.setTenantDomain(AuthenticationAuditLoggerUtils.getTenantDomainForAuthenticationStep(params));
            authenticationAuditData.setAuthenticatedIdps(AuthenticationAuditLoggerUtils.getIdentityProviderForAuthenticationStep(context));
            authenticationAuditData.setStepNo(AuthenticationAuditLoggerUtils.getStepNoForAuthenticationStep(context));
        } else if ("auditAuth".equals(authType)) {
            authenticationAuditData.setAuthenticatedUser(AuthenticationAuditLoggerUtils.getSubjectIdentifier(context, status));
            authenticationAuditData.setTenantDomain(AuthenticationAuditLoggerUtils.getTenantDomainForAuthentication(context, params, status));
            authenticationAuditData.setStepNo(AuthenticationAuditLoggerUtils.getStepNoForAuthentication(context, status));
            authenticationAuditData.setAuthenticatedIdps(AuthenticationAuditLoggerUtils.getIdentityProviderList(context, status));
        }
        return authenticationAuditData;
    }

    private static void setUserStoreDomain(AuthenticationAuditData authenticationAuditData, Object userObj) {
        if (userObj instanceof User) {
            User user = (User)userObj;
            authenticationAuditData.setUserStoreDomain(user.getUserStoreDomain());
        }
    }

    private static String getContextIdentifier(AuthenticationContext context) {
        return context.getContextIdentifier();
    }

    private static String getUserNameForAuthenticationStep(Map<String, Object> params) {
        User user;
        String userName = null;
        Object userObj = params.get("user");
        if (userObj instanceof User) {
            user = (User)userObj;
            userName = user.getUserName();
        }
        if (userObj instanceof AuthenticatedUser && StringUtils.isEmpty((String)(user = (AuthenticatedUser)userObj).getUserName())) {
            userName = user.getAuthenticatedSubjectIdentifier();
        }
        return userName;
    }

    private static String getTenantDomainForAuthenticationStep(Map<String, Object> params) {
        String tenantDomain = null;
        Object userObj = params.get("user");
        if (userObj instanceof User) {
            User user = (User)userObj;
            tenantDomain = user.getTenantDomain();
        }
        return tenantDomain;
    }

    private static String getTenantDomainForAuthentication(AuthenticationContext context, Map<String, Object> params, AuthenticatorStatus status) {
        String tenantDomain = null;
        Object userObj = params.get("user");
        if (userObj instanceof AuthenticatedUser) {
            AuthenticatedUser user = (AuthenticatedUser)userObj;
            if (status == AuthenticatorStatus.FAIL) {
                tenantDomain = user.getTenantDomain();
            }
        }
        if (status == AuthenticatorStatus.PASS) {
            AuthenticatedIdPData localIDPData = null;
            Map previousAuthenticatedIDPs = context.getPreviousAuthenticatedIdPs();
            Map currentAuthenticatedIDPs = context.getCurrentAuthenticatedIdPs();
            if (currentAuthenticatedIDPs != null && currentAuthenticatedIDPs.size() > 0) {
                localIDPData = (AuthenticatedIdPData)currentAuthenticatedIDPs.get("LOCAL");
            }
            if (localIDPData == null && previousAuthenticatedIDPs != null && previousAuthenticatedIDPs.size() > 0) {
                localIDPData = (AuthenticatedIdPData)previousAuthenticatedIDPs.get("LOCAL");
            }
            if (localIDPData != null) {
                tenantDomain = localIDPData.getUser().getTenantDomain();
            }
        }
        return tenantDomain;
    }

    private static String getServiceProvider(AuthenticationContext context) {
        return context.getServiceProviderName();
    }

    private static String getInboundProtocol(AuthenticationContext context) {
        return context.getRequestType();
    }

    private static String getRelyingParty(AuthenticationContext context) {
        return context.getRelyingParty();
    }

    private static String getIdentityProviderForAuthenticationStep(AuthenticationContext context) {
        String idpProvider = null;
        idpProvider = context.getExternalIdP() == null ? "LOCAL" : context.getExternalIdP().getIdPName();
        return idpProvider;
    }

    private static int getStepNoForAuthenticationStep(AuthenticationContext context) {
        return context.getCurrentStep();
    }

    private static int getStepNoForAuthentication(AuthenticationContext context, AuthenticatorStatus status) {
        int step = 0;
        if (status == AuthenticatorStatus.PASS) {
            Object hasLocalStepObj = context.getProperty("hasLocalStep");
            boolean hasPreviousLocalStep = AuthenticationAuditLoggerUtils.hasPreviousLocalEvent(context);
            boolean hasLocal = AuthenticationAuditLoggerUtils.convertToBoolean(hasLocalStepObj);
            if (!hasPreviousLocalStep && hasLocal) {
                step = AuthenticationAuditLoggerUtils.getLocalStepNo(context);
            }
        }
        return step;
    }

    private static String getSubjectIdentifier(AuthenticationContext context, AuthenticatorStatus status) {
        String subjectIdentifier = null;
        if (status == AuthenticatorStatus.PASS) {
            subjectIdentifier = context.getSequenceConfig().getAuthenticatedUser().getAuthenticatedSubjectIdentifier();
        }
        return subjectIdentifier;
    }

    private static String getIdentityProviderList(AuthenticationContext context, AuthenticatorStatus status) {
        String authenticatedIdps = null;
        if (status == AuthenticatorStatus.PASS) {
            authenticatedIdps = context.getSequenceConfig().getAuthenticatedIdPs();
        }
        return authenticatedIdps;
    }

    private static AuthenticationContext getAuthenticationContextFromProperties(Map<String, Object> properties) {
        return (AuthenticationContext)properties.get("context");
    }

    private static AuthenticatorStatus getAuthenticatorStatusFromProperties(Map<String, Object> properties) {
        return (AuthenticatorStatus)properties.get("authenticationStatus");
    }

    private static SessionContext getSessionContextFromProperties(Map<String, Object> properties) {
        return (SessionContext)properties.get("sessionContext");
    }

    private static Map<String, Object> getParamsFromProperties(Map<String, Object> properties) {
        return (Map)properties.get("params");
    }

    private static boolean hasPreviousLocalEvent(AuthenticationContext context) {
        Map previousAuthenticatedIDPs = context.getPreviousAuthenticatedIdPs();
        return previousAuthenticatedIDPs.get("LOCAL") != null;
    }

    private static boolean convertToBoolean(Object object) {
        if (object != null) {
            return (Boolean)object;
        }
        return false;
    }

    private static int getLocalStepNo(AuthenticationContext context) {
        int stepNo = 0;
        Map map = context.getSequenceConfig().getStepMap();
        for (Map.Entry entry : map.entrySet()) {
            StepConfig stepConfig = (StepConfig)entry.getValue();
            if (stepConfig == null || !"LOCAL".equalsIgnoreCase(stepConfig.getAuthenticatedIdP())) continue;
            stepNo = (Integer)entry.getKey();
            return stepNo;
        }
        return stepNo;
    }
}

