/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.SingletonItem;

public class ManualIterator
implements UnfailingIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private Item item;
    private int position;
    private LastPositionFinder lastPositionFinder;

    public ManualIterator() {
        this.item = null;
        this.position = 0;
    }

    public ManualIterator(Item value, int position) {
        this.item = value;
        this.position = position;
    }

    public void setContextItem(Item value) {
        this.item = value;
    }

    public void setLastPositionFinder(LastPositionFinder finder) {
        this.lastPositionFinder = finder;
    }

    public void incrementPosition() {
        ++this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean hasNext() {
        return false;
    }

    public Item next() {
        return null;
    }

    public Item current() {
        return this.item;
    }

    public int position() {
        return this.position;
    }

    public int getLength() throws XPathException {
        if (this.lastPositionFinder == null) {
            throw new UnsupportedOperationException("last() cannot be used when streaming");
        }
        return this.lastPositionFinder.getLength();
    }

    public void close() {
    }

    public UnfailingIterator getAnother() {
        return new ManualIterator(this.item, 1);
    }

    public UnfailingIterator getReverseIterator() {
        return new ManualIterator(this.item, 1);
    }

    public GroundedValue materialize() {
        if (this.item instanceof GroundedValue) {
            return (GroundedValue)((Object)this.item);
        }
        return new SingletonItem<Item>(this.item);
    }

    public int getProperties() {
        return 7;
    }
}

