/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.custom.lifecycles.checklist.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.cache.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.custom.lifecycles.checklist.beans.LifecycleBean;
import org.wso2.carbon.governance.custom.lifecycles.checklist.util.CommonUtil;
import org.wso2.carbon.governance.custom.lifecycles.checklist.util.LifecycleActions;
import org.wso2.carbon.governance.custom.lifecycles.checklist.util.Property;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.caching.RegistryCacheKey;
import org.wso2.carbon.registry.core.config.DataBaseConfiguration;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RemoteConfiguration;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.core.UserRealm;

public class LifecycleBeanPopulator {
    private static final Log log = LogFactory.getLog(LifecycleBeanPopulator.class);
    private static Map<String, Boolean> lifecycleAspects = new HashMap<String, Boolean>();
    private static final String LIFECYCLE_PATH = "/repository/components/org.wso2.carbon.governance/lifecycles/";

    public static LifecycleBean getLifecycleBean(String path, UserRegistry registry, Registry systemRegistry) throws Exception {
        LifecycleBean lifecycleBean;
        ResourcePath resourcePath = new ResourcePath(path);
        boolean isTransactionStarted = false;
        try {
            Resource resource = registry.get(path);
            if (resource != null) {
                List aspects;
                lifecycleBean = new LifecycleBean();
                lifecycleBean.setMediaType(resource.getMediaType());
                if (resource.getProperty("registry.link") != null && resource.getProperty("registry.mount") == null) {
                    lifecycleBean.setLink(true);
                    LifecycleBean lifecycleBean2 = lifecycleBean;
                    return lifecycleBean2;
                }
                if (resource.getProperty("registry.mount") != null) {
                    lifecycleBean.setMounted(true);
                }
                if ((aspects = resource.getAspects()) != null) {
                    LifecycleActions[] actions = new LifecycleActions[aspects.size()];
                    for (int i = 0; i < actions.length; ++i) {
                        String[] aspectActions;
                        String aspect = (String)aspects.get(i);
                        if (!Arrays.asList(registry.getAvailableAspects()).contains(aspect)) {
                            CommonUtil.generateAspect(LIFECYCLE_PATH + aspect, (Registry)CommonUtil.getRegistryService().getConfigSystemRegistry());
                        }
                        if ((aspectActions = registry.getAspectActions(resourcePath.getPath(), aspect)) == null) continue;
                        LifecycleActions lifecycleActionsEntry = new LifecycleActions();
                        lifecycleActionsEntry.setLifecycle(aspect);
                        lifecycleActionsEntry.setActions(aspectActions);
                        actions[i] = lifecycleActionsEntry;
                    }
                    lifecycleBean.setAvailableActions(actions);
                }
                String[] aspectsToAdd = registry.getAvailableAspects();
                LinkedList<String> lifecycleAspectsToAdd = new LinkedList<String>();
                if (aspectsToAdd != null) {
                    String tempResourcePath = "/governance/lcm/" + UUIDGenerator.generateUUID();
                    for (String string : aspectsToAdd) {
                        if (systemRegistry.getRegistryContext().isReadOnly()) {
                            lifecycleAspectsToAdd.add(string);
                            continue;
                        }
                        Boolean isLifecycleAspect = lifecycleAspects.get(string);
                        if (isLifecycleAspect == null) {
                            if (!isTransactionStarted) {
                                systemRegistry.beginTransaction();
                                isTransactionStarted = true;
                            }
                            systemRegistry.put(tempResourcePath, systemRegistry.newResource());
                            systemRegistry.associateAspect(tempResourcePath, string);
                            Resource r = systemRegistry.get(tempResourcePath);
                            Properties props = r.getProperties();
                            Set<Object> keys = props.keySet();
                            for (Object key : keys) {
                                String propKey = (String)key;
                                if (!propKey.startsWith("registry.lifecycle.") && !propKey.startsWith("registry.custom_lifecycle.checklist.")) continue;
                                isLifecycleAspect = Boolean.TRUE;
                                break;
                            }
                            if (isLifecycleAspect == null) {
                                isLifecycleAspect = Boolean.FALSE;
                            }
                            lifecycleAspects.put(string, isLifecycleAspect);
                        }
                        if (!isLifecycleAspect.booleanValue()) continue;
                        lifecycleAspectsToAdd.add(string);
                    }
                    if (isTransactionStarted) {
                        systemRegistry.delete(tempResourcePath);
                        systemRegistry.rollbackTransaction();
                        isTransactionStarted = false;
                    }
                }
                lifecycleBean.setAspectsToAdd(lifecycleAspectsToAdd.toArray(new String[lifecycleAspectsToAdd.size()]));
                LifecycleBeanPopulator.removeCache((Registry)registry, path);
                resource = registry.get(path);
                Properties props = resource.getProperties();
                ArrayList<Property> propList = new ArrayList<Property>();
                ArrayList<Property> voteList = new ArrayList<Property>();
                for (String string : props.keySet()) {
                    List propValues;
                    Property property;
                    if (string.startsWith("registry.lifecycle.") || string.startsWith("registry.custom_lifecycle.checklist.") && LifecycleBeanPopulator.isPropertyKeyContainsAspectName(aspects, string) || string.equals("registry.LC.name")) {
                        property = new Property();
                        property.setKey(string);
                        propValues = (List)props.get(string);
                        property.setValues(propValues.toArray(new String[propValues.size()]));
                        propList.add(property);
                        continue;
                    }
                    if (!string.startsWith("registry.custom_lifecycle.votes.option.")) continue;
                    property = new Property();
                    property.setKey(string);
                    propValues = (List)props.get(string);
                    if (string.endsWith(".vote")) {
                        boolean userVoted = false;
                        for (String propValue : propValues) {
                            if (!propValue.startsWith("users:")) continue;
                            String users = propValue.replace("users:", "");
                            String[] votedUsers = users.split(",");
                            userVoted = Arrays.asList(votedUsers).contains(registry.getUserName());
                        }
                        propValues.add("uservote:" + userVoted);
                    }
                    property.setValues(propValues.toArray(new String[propValues.size()]));
                    voteList.add(property);
                }
                lifecycleBean.setLifecycleProperties(propList.toArray(new Property[propList.size()]));
                lifecycleBean.setLifecycleApproval(voteList.toArray(new Property[voteList.size()]));
                lifecycleBean.setPathWithVersion(resourcePath.getPathWithVersion());
                lifecycleBean.setVersionView(!resourcePath.isCurrentVersion());
                lifecycleBean.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)resourcePath.getPath(), (UserRegistry)registry));
                lifecycleBean.setLoggedIn(!"wso2.anonymous.user".equals(registry.getUserName()));
                lifecycleBean.setShowAddDelete(true);
                UserRealm userRealm = registry.getUserRealm();
                String[] stringArray = userRealm.getUserStoreManager().getRoleListOfUser(registry.getUserName());
                lifecycleBean.setRolesOfUser(stringArray);
                resource.discard();
            } else {
                lifecycleBean = null;
            }
        }
        catch (ResourceNotFoundException rnfe) {
            lifecycleBean = null;
        }
        catch (RegistryException e) {
            String msg = "Failed to get life cycle information of resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        finally {
            if (isTransactionStarted) {
                systemRegistry.rollbackTransaction();
            }
        }
        return lifecycleBean;
    }

    private static void removeCache(Registry registry, String path) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Cache cache = RegistryUtils.getResourceCache((String)"REG_CACHE_BACKED_ID");
        RegistryCacheKey cacheKey = null;
        if (registry.getRegistryContext().getRemoteInstances().size() > 0) {
            for (Mount mount : registry.getRegistryContext().getMounts()) {
                for (RemoteConfiguration configuration : registry.getRegistryContext().getRemoteInstances()) {
                    DataBaseConfiguration dataBaseConfiguration;
                    String connectionId;
                    if (!path.startsWith(mount.getPath()) || (cacheKey = RegistryUtils.buildRegistryCacheKey((String)(connectionId = ((dataBaseConfiguration = registry.getRegistryContext().getDBConfig(configuration.getDbConfig())).getUserName() != null ? dataBaseConfiguration.getUserName().split("@")[0] : dataBaseConfiguration.getUserName()) + "@" + dataBaseConfiguration.getDbUrl()), (int)tenantId, (String)path)) == null || !cache.containsKey((Object)cacheKey)) continue;
                    cache.remove((Object)cacheKey);
                }
            }
        } else {
            DataBaseConfiguration dataBaseConfiguration = registry.getRegistryContext().getDefaultDataBaseConfiguration();
            String connectionId = (dataBaseConfiguration.getUserName() != null ? dataBaseConfiguration.getUserName().split("@")[0] : dataBaseConfiguration.getUserName()) + "@" + dataBaseConfiguration.getDbUrl();
            cacheKey = RegistryUtils.buildRegistryCacheKey((String)connectionId, (int)tenantId, (String)path);
            if (cacheKey != null && cache.containsKey((Object)cacheKey)) {
                cache.remove((Object)cacheKey);
            }
        }
    }

    private static boolean isPropertyKeyContainsAspectName(List<String> aspects, String propKey) {
        if (aspects != null) {
            for (String aspect : aspects) {
                if (!propKey.contains(aspect)) continue;
                return true;
            }
        }
        return false;
    }
}

