/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.custom.lifecycles.checklist.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class InvokeAspectUtil {
    private static final Log log = LogFactory.getLog(InvokeAspectUtil.class);

    public static void invokeAspect(String path, String aspect, String action, String[] items, Registry registry, Map<String, String> parameters) throws Exception {
        try {
            if (parameters.size() == 0) {
                parameters = new HashMap<String, String>();
            }
            String itemType = "voteClick".equals(action) ? ".vote" : ".item";
            for (int i = 0; i < items.length; ++i) {
                parameters.put(i + itemType, items[i]);
            }
            if (parameters.size() > 0) {
                registry.invokeAspect(path, aspect, action, parameters);
            } else {
                registry.invokeAspect(path, aspect, action);
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to invoke action " + action + " of aspect " + aspect + " on resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }
}

