/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.custom.lifecycles.checklist.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryConfigurationProcessor;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static RegistryService registryService;

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static String[] getAllDependencies(String path, Registry registry) throws Exception {
        Set<String> retList = CommonUtil.getAllDependenciesRecursive(path, registry);
        String[] retString = new String[retList.size()];
        return retList.toArray(retString);
    }

    public static Set<String> getAllDependenciesRecursive(String path, Registry registry) throws Exception {
        Association[] dependencies = registry.getAssociations(path, "depends");
        HashSet<String> allAssociations = new HashSet<String>();
        for (Association dependency : dependencies) {
            if (!dependency.getSourcePath().equals(path) || dependency.getSourcePath().equals(dependency.getDestinationPath())) continue;
            allAssociations.addAll(CommonUtil.getAllDependenciesRecursive(dependency.getDestinationPath(), registry));
        }
        allAssociations.add(RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)path));
        return allAssociations;
    }

    public static boolean generateAspect(String resourceFullPath, Registry registry) throws RegistryException, XMLStreamException {
        RegistryContext registryContext = registry.getRegistryContext();
        if (registryContext == null) {
            return false;
        }
        Resource resource = registry.get(resourceFullPath);
        if (resource != null) {
            OMElement aspect;
            String content = null;
            if (resource.getContent() != null) {
                content = RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            }
            if (content != null && (aspect = AXIOMUtil.stringToOM(content)) != null) {
                OMElement dummy = OMAbstractFactory.getOMFactory().createOMElement("dummy", null);
                dummy.addChild((OMNode)aspect);
                Aspect aspectinstance = RegistryConfigurationProcessor.updateAspects((OMElement)dummy);
                Iterator aspectElement = dummy.getChildrenWithName(new QName("aspect"));
                String name = "";
                if (aspectElement != null) {
                    OMElement aspectelement = (OMElement)aspectElement.next();
                    name = aspectelement.getAttributeValue(new QName("name"));
                }
                registry.addAspect(name, aspectinstance);
                return true;
            }
        }
        return false;
    }
}

