/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.custom.lifecycles.checklist.services;

import java.util.Collections;
import java.util.HashMap;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.custom.lifecycles.checklist.beans.LifecycleBean;
import org.wso2.carbon.governance.custom.lifecycles.checklist.util.CommonUtil;
import org.wso2.carbon.governance.custom.lifecycles.checklist.util.InvokeAspectUtil;
import org.wso2.carbon.governance.custom.lifecycles.checklist.util.LifecycleBeanPopulator;
import org.wso2.carbon.registry.admin.api.governance.IChecklistLifecycleService;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class LifecyclesAdminService
extends RegistryAbstractAdmin
implements IChecklistLifecycleService {
    public LifecycleBean getLifecycleBean(String path) throws Exception {
        return LifecycleBeanPopulator.getLifecycleBean(path, (UserRegistry)this.getRootRegistry(), this.getConfigSystemRegistry());
    }

    public void addAspect(String path, String aspect) throws Exception {
        RegistryUtils.recordStatistics((Object[])new Object[]{path, aspect});
        GovernanceUtils.associateAspect((String)path, (String)aspect, (Registry)this.getRootRegistry());
    }

    public void invokeAspect(String path, String aspect, String action, String[] items) throws Exception {
        RegistryUtils.recordStatistics((Object[])new Object[]{path, aspect, action, items});
        InvokeAspectUtil.invokeAspect(path, aspect, action, items, this.getRootRegistry(), Collections.emptyMap());
    }

    public void invokeAspectWithParams(String path, String aspect, String action, String[] items, String[][] parameters) throws Exception {
        RegistryUtils.recordStatistics((Object[])new Object[]{path, aspect, action, items, parameters});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String[] strings : parameters) {
            if (strings == null || strings.length != 2) continue;
            paramMap.put(strings[0], strings[1]);
        }
        InvokeAspectUtil.invokeAspect(path, aspect, action, items, this.getRootRegistry(), paramMap);
    }

    public void removeAspect(String path, String aspect) throws Exception {
        RegistryUtils.recordStatistics((Object[])new Object[]{path, aspect});
        GovernanceUtils.removeAspect((String)path, (String)aspect, (Registry)this.getRootRegistry());
    }

    public String[] getAllDependencies(String path) throws Exception {
        return CommonUtil.getAllDependencies(path, this.getRootRegistry());
    }

    public void setDefaultAspect(String path, String aspect) throws Exception {
        RegistryUtils.recordStatistics((Object[])new Object[]{path, aspect});
        GovernanceUtils.setDefaultLifeCycle((String)path, (String)aspect, (Registry)this.getRootRegistry());
    }
}

