/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.roles.mgt.ui;

import java.rmi.RemoteException;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.roles.mgt.stub.AddServerRolesServerRolesExceptionException;
import org.wso2.carbon.roles.mgt.stub.ReadServerRolesServerRolesExceptionException;
import org.wso2.carbon.roles.mgt.stub.RemoveServerRolesServerRolesExceptionException;
import org.wso2.carbon.roles.mgt.stub.ServerRolesManagerStub;

public class ServerRoleManagerClient {
    private static Log log = LogFactory.getLog(ServerRoleManagerClient.class);
    public ServerRolesManagerStub stub;

    public ServerRoleManagerClient(ConfigurationContext configCtx, String backendServerURL, String cookie) throws Exception {
        String serviceURL = backendServerURL + "ServerRolesManager";
        this.stub = new ServerRolesManagerStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public String[] getServerRoles(String serverRoleType) throws Exception {
        String[] serverRoles = new String[]{};
        try {
            serverRoles = this.stub.readServerRoles(serverRoleType);
        }
        catch (RemoteException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (ReadServerRolesServerRolesExceptionException e) {
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
        return serverRoles;
    }

    public boolean deleteServerRoles(String[] serverRolestoDelete, String serverRoleType) throws Exception {
        boolean status = false;
        try {
            status = this.stub.removeServerRoles(serverRolestoDelete, serverRoleType);
        }
        catch (RemoteException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (RemoveServerRolesServerRolesExceptionException e) {
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
        return status;
    }

    public boolean addServerRoles(String[] serverRolestoAdd, String serverRoleType) throws Exception {
        boolean status = false;
        try {
            status = this.stub.addServerRoles(serverRolestoAdd, serverRoleType);
        }
        catch (RemoteException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (AddServerRolesServerRolesExceptionException e) {
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
        return status;
    }

    public void handleException(String message, Exception e) throws Exception {
        log.error((Object)message);
        throw new Exception(message, e);
    }
}

