/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class URLMappingHolder {
    private static ConcurrentHashMap<String, String> urlMappingOfApplication = new ConcurrentHashMap();
    private static URLMappingHolder urlMappingHolder = new URLMappingHolder();
    private String defaultHost;

    private URLMappingHolder() {
    }

    public static URLMappingHolder getInstance() {
        return urlMappingHolder;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
    }

    public void putUrlMappingForApplication(String urlMapping, String application) {
        urlMappingOfApplication.put(urlMapping, application);
    }

    public String getApplicationFromUrlMapping(String urlMapping) {
        return urlMappingOfApplication.get(urlMapping);
    }

    public void removeUrlMappingMap(String urlMapping) {
        urlMappingOfApplication.remove(urlMapping);
    }

    public boolean isUrlMappingExists(String urlMapping) {
        return urlMappingOfApplication.containsKey(urlMapping);
    }

    public List<String> getUrlMappingsPerApplication(String applicationContext) {
        ArrayList<String> urlMapping = new ArrayList<String>();
        for (String key : urlMappingOfApplication.keySet()) {
            if (!urlMappingOfApplication.get(key).equalsIgnoreCase(applicationContext)) continue;
            urlMapping.add(key);
        }
        return urlMapping;
    }

    public Map<String, String> getUrlMappingOfApplication() {
        return urlMappingOfApplication;
    }
}

