/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.transport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.tomcat.ext.internal.CarbonTomcatServiceHolder;

public class ServletTransportManager {
    private static Log log = LogFactory.getLog(ServletTransportManager.class);
    private static int httpPort;
    private static int httpsPort;
    private static int httpProxyPort;
    private static int httpsProxyPort;
    private static int portOffset;

    public static void init() {
        int tempHttpsProxyPort;
        ServerConfigurationService serverConfigurationService = CarbonTomcatServiceHolder.getServerConfigurationService();
        String portOffset = System.getProperty("portOffset", serverConfigurationService.getFirstProperty("Ports.Offset"));
        ServletTransportManager.portOffset = Integer.parseInt(portOffset);
        httpPort = CarbonTomcatServiceHolder.getCarbonTomcatService().getPort("http") + ServletTransportManager.portOffset;
        System.setProperty("mgt.transport.http.port", String.valueOf(httpPort));
        httpsPort = CarbonTomcatServiceHolder.getCarbonTomcatService().getPort("https") + ServletTransportManager.portOffset;
        System.setProperty("mgt.transport.https.port", String.valueOf(httpsPort));
        int tempHttpProxyPort = CarbonTomcatServiceHolder.getCarbonTomcatService().getProxyPort("http");
        if (tempHttpProxyPort > 0) {
            httpProxyPort = tempHttpProxyPort;
            System.setProperty("mgt.transport.http.proxyPort", String.valueOf(tempHttpProxyPort));
        }
        if ((tempHttpsProxyPort = CarbonTomcatServiceHolder.getCarbonTomcatService().getProxyPort("https")) > 0) {
            httpsProxyPort = tempHttpsProxyPort;
            System.setProperty("mgt.transport.https.proxyPort", String.valueOf(tempHttpsProxyPort));
        }
    }

    public static int getPort(String scheme) {
        if ("http".equals(scheme)) {
            return httpPort;
        }
        if ("https".equals(scheme)) {
            return httpsPort;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unrecognized transport scheme" + scheme));
        }
        return -1;
    }

    public static int getProxyPort(String scheme) {
        if ("http".equals(scheme)) {
            return httpProxyPort;
        }
        if ("https".equals(scheme)) {
            return httpsProxyPort;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unrecognized transport scheme" + scheme));
        }
        return -1;
    }

    public static void startTransports() {
        CarbonTomcatServiceHolder.getCarbonTomcatService().startConnectors(portOffset);
    }

    public static void stopTransports() {
        if (ServerStatus.getCurrentStatus().equals("RUNNING")) {
            CarbonTomcatServiceHolder.getCarbonTomcatService().stopConnectors();
        }
    }

    public static void startTransport(String scheme) {
        CarbonTomcatServiceHolder.getCarbonTomcatService().startConnector(scheme, portOffset);
    }

    public static void stopTransport(String scheme) {
        if (ServerStatus.getCurrentStatus().equals("RUNNING")) {
            CarbonTomcatServiceHolder.getCarbonTomcatService().stopConnector(scheme);
        }
    }

    static {
        httpProxyPort = -1;
        httpsProxyPort = -1;
    }
}

