/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect.model;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.wso2.carbon.identity.oauth2.RequestObjectException;
import org.wso2.carbon.identity.openidconnect.model.RequestedClaim;

public class RequestObject
implements Serializable {
    private static final long serialVersionUID = 7180827153818376043L;
    public static final String CLAIMS = "claims";
    public static final String ESSENTIAL = "essential";
    public static final String VALUE = "value";
    public static final String VALUES = "values";
    private boolean isSignatureValid;
    private SignedJWT signedJWT;
    private PlainJWT plainJWT;
    private JWTClaimsSet claimsSet;
    private Map<String, List<RequestedClaim>> requestedClaims = new HashMap<String, List<RequestedClaim>>();

    public boolean isSignatureValid() {
        return this.isSignatureValid;
    }

    public void setIsSignatureValid(boolean isSignatureValid) {
        this.isSignatureValid = isSignatureValid;
    }

    public boolean isSigned() {
        return this.signedJWT != null;
    }

    public PlainJWT getPlainJWT() {
        return this.plainJWT;
    }

    public void setPlainJWT(PlainJWT plainJWT) throws RequestObjectException {
        this.plainJWT = plainJWT;
        try {
            this.setClaimSet(plainJWT.getJWTClaimsSet());
        }
        catch (ParseException e) {
            throw new RequestObjectException("invalid_request", "Unable to parse Claim Set in the Request Object.");
        }
        if (this.claimsSet.getClaim(CLAIMS) != null) {
            JSONObject claims = this.claimsSet.toJSONObject();
            this.processClaimObject(claims);
        }
    }

    public Map<String, List<RequestedClaim>> getRequestedClaims() {
        return this.requestedClaims;
    }

    public void setRequestedClaims(Map<String, List<RequestedClaim>> claimsforRequestParameter) {
        this.requestedClaims = claimsforRequestParameter;
    }

    public SignedJWT getSignedJWT() {
        return this.signedJWT;
    }

    public void setSignedJWT(SignedJWT signedJWT) throws RequestObjectException {
        this.signedJWT = signedJWT;
        try {
            this.setClaimSet(signedJWT.getJWTClaimsSet());
        }
        catch (ParseException e) {
            throw new RequestObjectException("invalid_request", "Unable to parse Claim Set in the Request Object.");
        }
        if (this.claimsSet.getClaim(CLAIMS) != null) {
            JSONObject claims = this.claimsSet.toJSONObject();
            this.processClaimObject(claims);
        }
    }

    public void setClaimSet(JWTClaimsSet claimSet) {
        this.claimsSet = claimSet;
    }

    public JWTClaimsSet getClaimsSet() {
        return this.claimsSet;
    }

    private void processClaimObject(JSONObject jsonObjectRequestedClaims) throws RequestObjectException {
        try {
            HashMap<String, List<RequestedClaim>> claimsforClaimRequestor = new HashMap<String, List<RequestedClaim>>();
            if (jsonObjectRequestedClaims.get((Object)CLAIMS) != null) {
                JSONObject jsonObjectClaim = (JSONObject)jsonObjectRequestedClaims.get((Object)CLAIMS);
                for (Map.Entry requesterClaimsMap : jsonObjectClaim.entrySet()) {
                    JSONObject jsonObjectAllRequestedClaims;
                    Object requestedClaimObject;
                    ArrayList<RequestedClaim> requestedClaimsList = new ArrayList<RequestedClaim>();
                    if (jsonObjectClaim.get(requesterClaimsMap.getKey()) != null && (requestedClaimObject = jsonObjectClaim.get(requesterClaimsMap.getKey())) instanceof JSONObject && (jsonObjectAllRequestedClaims = (JSONObject)jsonObjectClaim.get(requesterClaimsMap.getKey())) != null) {
                        for (Map.Entry requestedClaims : jsonObjectAllRequestedClaims.entrySet()) {
                            JSONObject jsonObjectClaimAttributes = null;
                            if (jsonObjectAllRequestedClaims.get(requestedClaims.getKey()) != null) {
                                jsonObjectClaimAttributes = (JSONObject)jsonObjectAllRequestedClaims.get(requestedClaims.getKey());
                            }
                            this.populateRequestedClaimValues(requestedClaimsList, jsonObjectClaimAttributes, (String)requestedClaims.getKey(), (String)requesterClaimsMap.getKey());
                        }
                    }
                    claimsforClaimRequestor.put((String)requesterClaimsMap.getKey(), (List<RequestedClaim>)requestedClaimsList);
                }
                this.setRequestedClaims(claimsforClaimRequestor);
            }
        }
        catch (ClassCastException e) {
            throw new RequestObjectException("invalid_request", "Requested \"claims\" in Request Object is in invalid format.");
        }
    }

    private void populateRequestedClaimValues(List<RequestedClaim> requestedClaims, JSONObject jsonObjectClaimAttributes, String claimName, String claimType) {
        RequestedClaim claim = new RequestedClaim();
        claim.setName(claimName);
        claim.setType(claimType);
        if (jsonObjectClaimAttributes != null) {
            for (Map.Entry claimAttributes : jsonObjectClaimAttributes.entrySet()) {
                if (jsonObjectClaimAttributes.get(claimAttributes.getKey()) != null) {
                    JSONArray jsonArray;
                    Object value = jsonObjectClaimAttributes.get(claimAttributes.getKey());
                    if (ESSENTIAL.equals(claimAttributes.getKey())) {
                        claim.setEssential((Boolean)value);
                    } else if (VALUE.equals(claimAttributes.getKey())) {
                        claim.setValue((String)value);
                    } else if (VALUES.equals(claimAttributes.getKey()) && (jsonArray = (JSONArray)value) != null && jsonArray.size() > 0) {
                        ArrayList<String> values = new ArrayList<String>();
                        for (Object aJsonArray : jsonArray) {
                            values.add(aJsonArray.toString());
                        }
                        claim.setValues(values);
                    }
                }
                requestedClaims.add(claim);
            }
        } else {
            requestedClaims.add(claim);
        }
    }

    public String getClaimValue(String claimName) {
        try {
            return this.claimsSet.getStringClaim(claimName);
        }
        catch (ParseException e) {
            return "";
        }
    }

    public Object getClaim(String claimName) {
        return this.claimsSet.getClaim(claimName);
    }
}

