/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect.internal;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.SSOConsentService;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementService;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.identity.openidconnect.ClaimProvider;
import org.wso2.carbon.identity.openidconnect.OpenIDConnectClaimFilter;
import org.wso2.carbon.identity.openidconnect.OpenIDConnectSystemClaimImpl;
import org.wso2.carbon.identity.openidconnect.RequestObjectService;
import org.wso2.carbon.identity.openidconnect.handlers.RequestObjectHandler;
import org.wso2.carbon.identity.openidconnect.internal.OpenIDConnectServiceComponentHolder;

@Component(name="identity.openidconnect.component", immediate=true)
public class OpenIDConnectServiceComponent {
    private static final Log log = LogFactory.getLog(OpenIDConnectServiceComponent.class);
    private BundleContext bundleContext;

    protected void activate(ComponentContext context) {
        try {
            this.bundleContext = context.getBundleContext();
            this.bundleContext.registerService(ClaimProvider.class.getName(), (Object)new OpenIDConnectSystemClaimImpl(), null);
            this.bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new RequestObjectHandler(), null);
            this.bundleContext.registerService(RequestObjectService.class.getName(), (Object)new RequestObjectService(), null);
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating OpenIDConnectServiceComponent.", e);
        }
    }

    @Reference(name="openid.connect.claim.filter.service", service=OpenIDConnectClaimFilter.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetOpenIDConnectClaimFilter")
    protected void setOpenIDConnectClaimFilter(OpenIDConnectClaimFilter openIDConnectClaimFilter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OpenIDConnectClaimFilter: " + openIDConnectClaimFilter.getClass().getName() + " set in OpenIDConnectServiceComponent."));
        }
        OpenIDConnectServiceComponentHolder.getInstance().getOpenIDConnectClaimFilters().add(openIDConnectClaimFilter);
        OpenIDConnectServiceComponentHolder.getInstance().getOpenIDConnectClaimFilters().sort(this.getOIDCClaimFilterComparator());
    }

    private Comparator<OpenIDConnectClaimFilter> getOIDCClaimFilterComparator() {
        return Comparator.comparingInt(OpenIDConnectClaimFilter::getPriority).reversed();
    }

    protected void unsetOpenIDConnectClaimFilter(OpenIDConnectClaimFilter openIDConnectClaimFilter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OpenIDConnectClaimFilter: " + openIDConnectClaimFilter.getClass().getName() + " unset in OpenIDConnectServiceComponent."));
        }
        OpenIDConnectServiceComponentHolder.getInstance().getOpenIDConnectClaimFilters().remove(openIDConnectClaimFilter);
        OpenIDConnectServiceComponentHolder.getInstance().getOpenIDConnectClaimFilters().sort(this.getOIDCClaimFilterComparator());
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="ClaimProvider", service=ClaimProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetClaimProvider")
    protected void setClaimProvider(ClaimProvider claimProvider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting ClaimProvider Service " + claimProvider.getClass().getName()));
        }
        OpenIDConnectServiceComponentHolder.getInstance().getClaimProviders().add(claimProvider);
    }

    protected void unsetClaimProvider(ClaimProvider claimProvider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unsetting ClaimProvider Service " + claimProvider.getClass().getName()));
        }
        OpenIDConnectServiceComponentHolder.getInstance().getClaimProviders().remove(claimProvider);
    }

    @Reference(name="org.wso2.carbon.identity.event.services. ", service=IdentityEventService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityEventService")
    protected void setIdentityEventService(IdentityEventService identityEventService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"IdentityEventService set in OpenIDConnectServiceComponent bundle");
        }
        OpenIDConnectServiceComponentHolder.setIdentityEventService(identityEventService);
    }

    protected void unsetIdentityEventService(IdentityEventService identityEventService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"IdentityEventService unset in OpenIDConnectServiceComponent bundle");
        }
        OpenIDConnectServiceComponentHolder.setIdentityEventService(null);
    }

    @Reference(name="identity.openidconnect.RequestObjectService", service=RequestObjectService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRequestObjectService")
    protected void setRequestObjectService(RequestObjectService requestObjectService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting RequestObjectService in OpenIDConnectServiceComponent bundle.");
        }
        OpenIDConnectServiceComponentHolder.setRequestObjectService(requestObjectService);
    }

    protected void unsetRequestObjectService(RequestObjectService requestObjectService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting RequestObjectService in OpenIDConnectServiceComponent bundle.");
        }
        OpenIDConnectServiceComponentHolder.setRequestObjectService(null);
    }

    @Reference(name="identity.openidconnect.handlers", service=RequestObjectHandler.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRequestObjectRevokeHandler")
    protected void setRequestObjectRevokeHandler(RequestObjectHandler requestObjectHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestObjectHandler set in OpenIDConnectServiceComponent bundle");
        }
        OpenIDConnectServiceComponentHolder.setRequestObjectHandler(requestObjectHandler);
    }

    protected void unsetRequestObjectRevokeHandler(RequestObjectHandler requestObjectHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RequestObjectHandler unset in OpenIDConnectServiceComponent bundle");
        }
        OpenIDConnectServiceComponentHolder.setRequestObjectHandler(null);
    }

    @Reference(name="claim.manager.listener.service", service=ClaimMetadataManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetClaimManagementService")
    protected void setClaimManagementService(ClaimMetadataManagementService claimMetadataManagementService) {
        OpenIDConnectServiceComponentHolder.getInstance().setClaimMetadataManagementService(claimMetadataManagementService);
    }

    protected void unsetClaimManagementService(ClaimMetadataManagementService claimMetadataManagementService) {
        OpenIDConnectServiceComponentHolder.getInstance().setClaimMetadataManagementService(null);
    }

    @Reference(name="sso.consent.service", service=SSOConsentService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConsentManagementService")
    protected void setConsentManagementService(SSOConsentService ssoConsentService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the SSOConsentService.");
        }
        OpenIDConnectServiceComponentHolder.getInstance().setSsoConsentService(ssoConsentService);
    }

    protected void unsetConsentManagementService(SSOConsentService ssoConsentService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un setting the SSOConsentService");
        }
        OpenIDConnectServiceComponentHolder.getInstance().setSsoConsentService(null);
    }
}

