/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect.handlers;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.model.AuthzCodeDO;

public class RequestObjectHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(RequestObjectHandler.class);

    public void handleEvent(Event event) throws IdentityEventException {
        Map eventProperties = event.getEventProperties();
        String eventName = event.getEventName();
        try {
            String tokenState = (String)eventProperties.get("TOKEN_STATE");
            String sessionDataKey = (String)eventProperties.get("SESSION_DATA_KEY");
            if ("POST_REVOKE_ACESS_TOKEN".equals(eventName)) {
                this.handlePostRevokeToken(eventProperties, tokenState);
            } else if ("POST_REVOKE_CODE".equals(eventName)) {
                this.handlePostRevokeCode(eventProperties, tokenState);
            } else if ("POST_REVOKE_CODE_BY_ID".equals(eventName)) {
                this.revokeCodeById(eventProperties, tokenState);
            } else if ("POST_REVOKE_ACESS_TOKEN_BY_ID".equals(eventName)) {
                this.postRevokeTokenById(eventProperties, tokenState);
            } else if ("POST_REFRESH_TOKEN".equals(eventName)) {
                this.postRefreshToken(eventProperties);
            } else if ("POST_ISSUE_CODE".equals(eventName)) {
                this.postIssueCode(eventProperties, sessionDataKey);
            } else if ("POST_ISSUE_ACCESS_TOKEN".equals(eventName)) {
                this.postIssueTOken(eventProperties, sessionDataKey);
            }
        }
        catch (IdentityOAuthAdminException | IdentityOAuth2Exception e) {
            String errorMsg = "Error while handling event: " + eventName;
            log.info((Object)errorMsg);
            throw new IdentityEventException(errorMsg, e.getMessage());
        }
    }

    private void postIssueTOken(Map<String, Object> eventProperties, String sessionDataKey) throws IdentityOAuth2Exception {
        String tokenId = (String)eventProperties.get("TOKEN_ID");
        OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().updateRequestObjectReferencebyTokenId(sessionDataKey, tokenId);
    }

    private void postIssueCode(Map<String, Object> eventProperties, String sessionDataKey) throws IdentityOAuth2Exception {
        String codeId = (String)eventProperties.get("CODE_ID");
        OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().updateRequestObjectReferencebyCodeId(sessionDataKey, codeId);
    }

    private void postRefreshToken(Map<String, Object> eventProperties) throws IdentityOAuth2Exception {
        String oldAccessToken = (String)eventProperties.get("OLD_ACCESS_TOKEN");
        String newAccessToken = (String)eventProperties.get("NEW_ACCESS_TOKEN");
        OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().refreshRequestObjectReference(oldAccessToken, newAccessToken);
    }

    private void revokeCodeById(Map<String, Object> eventProperties, String codeState) throws IdentityOAuth2Exception, IdentityOAuthAdminException {
        String tokenId = (String)eventProperties.get("TOKEN_ID");
        String codeId = (String)eventProperties.get("CODE_ID");
        if (StringUtils.isNotEmpty((String)tokenId) && "INACTIVE".equals(codeState)) {
            OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().updateRequestObjectReferenceCodeToToken(codeId, tokenId);
        } else if (this.isCodeRemoved(codeState)) {
            OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().deleteRequestObjectReferenceByCode(codeId);
        }
    }

    private void postRevokeTokenById(Map<String, Object> eventProperties, String tokenState) throws IdentityOAuth2Exception, IdentityOAuthAdminException {
        if (this.isCodeRemoved(tokenState)) {
            String tokenId = (String)eventProperties.get("TOKEN_ID");
            OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().deleteRequestObjectReferenceByTokenId(tokenId);
        }
    }

    private void handlePostRevokeCode(Map<String, Object> eventProperties, String codeState) throws IdentityOAuth2Exception, IdentityOAuthAdminException {
        boolean isCodeRemove = this.isCodeRemoved(codeState);
        List authzcodes = (List)eventProperties.get("CODES");
        for (AuthzCodeDO authzCodeDO : authzcodes) {
            String codeId = authzCodeDO.getAuthzCodeId();
            String tokenId = authzCodeDO.getOauthTokenId();
            if (isCodeRemove) {
                OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().deleteRequestObjectReferenceByCode(codeId);
                continue;
            }
            if (!StringUtils.isNotEmpty((String)tokenId) || !"INACTIVE".equals(codeState)) continue;
            OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().updateRequestObjectReferenceCodeToToken(codeId, tokenId);
        }
    }

    private void handlePostRevokeToken(Map<String, Object> eventProperties, String tokenState) throws IdentityOAuth2Exception, IdentityOAuthAdminException {
        if (this.isTokenRemoved(tokenState)) {
            List accessTokens = (List)eventProperties.get("ACEESS_TOKENS");
            for (String accessToken : accessTokens) {
                OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().deleteRequestObjectReferenceByTokenId(accessToken);
            }
        }
    }

    private boolean isTokenRemoved(String tokenState) {
        return "EXPIRED".equals(tokenState) || "REVOKED".equals(tokenState);
    }

    private boolean isCodeRemoved(String codeState) {
        return "EXPIRED".equals(codeState) || "REVOKED".equals(codeState);
    }

    public String getName() {
        return "handleRequestObject";
    }
}

