/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect.dao;

import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.database.utils.jdbc.exceptions.TransactionException;
import org.wso2.carbon.identity.core.util.LambdaExceptionUtils;
import org.wso2.carbon.identity.oauth.dto.ScopeDTO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ClientException;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.Oauth2ScopeConstants;
import org.wso2.carbon.identity.oauth2.util.JdbcUtils;
import org.wso2.carbon.identity.openidconnect.dao.ScopeClaimMappingDAO;

public class ScopeClaimMappingDAOImpl
implements ScopeClaimMappingDAO {
    private static final Log log = LogFactory.getLog(ScopeClaimMappingDAOImpl.class);
    private static final String OIDC_DIALECT_URI = "http://wso2.org/oidc/claim";

    @Override
    public void addScopes(int tenantId, List<ScopeDTO> scopeClaimsList) throws IdentityOAuth2Exception {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        scopeClaimsList.forEach(LambdaExceptionUtils.rethrowConsumer(scopeDTO -> {
            String scope = scopeDTO.getName();
            Object[] claims = scopeDTO.getClaim();
            if (!this.isScopeExist(scope, tenantId, true)) {
                try {
                    int scopeClaimMappingId = jdbcTemplate.executeInsert("INSERT INTO IDN_OAUTH2_SCOPE (NAME, DISPLAY_NAME, DESCRIPTION, TENANT_ID, SCOPE_TYPE) VALUES(?,?,?,?,?)", preparedStatement -> {
                        preparedStatement.setString(1, scope);
                        preparedStatement.setString(2, scopeDTO.getDisplayName());
                        preparedStatement.setString(3, scopeDTO.getDescription());
                        preparedStatement.setInt(4, tenantId);
                        preparedStatement.setString(5, "OIDC");
                    }, null, true, "SCOPE_ID");
                    if (scopeClaimMappingId > 0 && ArrayUtils.isNotEmpty((Object[])claims)) {
                        HashSet<Object> claimsSet = new HashSet<Object>(Arrays.asList(claims));
                        this.insertClaims(tenantId, scopeClaimMappingId, claimsSet);
                    }
                    if (!log.isDebugEnabled() || !ArrayUtils.isNotEmpty((Object[])claims)) return;
                    log.debug((Object)("The scope: " + scope + " and the claims: " + Arrays.asList(claims) + "are successfully inserted for the tenant: " + tenantId));
                    return;
                }
                catch (DataAccessException e) {
                    if (e.getCause() instanceof SQLIntegrityConstraintViolationException) {
                        int scopeClaimMappingId = this.getScopeId(scope, tenantId);
                        if (scopeClaimMappingId <= 0) return;
                        log.warn((Object)("Scope " + scope + " already exist in tenant " + tenantId + " , hence ignoring"));
                        return;
                    }
                    String errorMessage = "Error while persisting new claims for the scope for the tenant: " + tenantId;
                    throw new IdentityOAuth2Exception(errorMessage, e);
                }
            } else {
                log.warn((Object)String.format("Scope %s already exist in tenant %s.", scope, tenantId));
                throw new IdentityOAuth2ClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_CONFLICT_REQUEST_EXISTING_SCOPE.getCode(), String.format(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_CONFLICT_REQUEST_EXISTING_SCOPE.getMessage(), scope));
            }
        }));
    }

    @Override
    @Deprecated
    public void addScope(int tenantId, String scope, String[] claims) throws IdentityOAuth2Exception {
        ScopeDTO scopeDTO = new ScopeDTO(scope, scope, null, claims);
        this.addScope(scopeDTO, tenantId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addScope(ScopeDTO scope, int tenantId) throws IdentityOAuth2Exception {
        if (!this.isScopeExist(scope.getName(), tenantId, true)) {
            JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
            try {
                int scopeClaimMappingId = jdbcTemplate.executeInsert("INSERT INTO IDN_OAUTH2_SCOPE (NAME, DISPLAY_NAME, DESCRIPTION, TENANT_ID, SCOPE_TYPE) VALUES(?,?,?,?,?)", preparedStatement -> {
                    preparedStatement.setString(1, scope.getName());
                    preparedStatement.setString(2, scope.getDisplayName());
                    preparedStatement.setString(3, scope.getDescription());
                    preparedStatement.setInt(4, tenantId);
                    preparedStatement.setString(5, "OIDC");
                }, null, true, "SCOPE_ID");
                if (scopeClaimMappingId > 0 && ArrayUtils.isNotEmpty((Object[])scope.getClaim())) {
                    HashSet<String> claimsSet = new HashSet<String>(Arrays.asList(scope.getClaim()));
                    this.insertClaims(tenantId, scopeClaimMappingId, claimsSet);
                }
                if (!log.isDebugEnabled() || !ArrayUtils.isNotEmpty((Object[])scope.getClaim())) return;
                log.debug((Object)String.format("The scope %s and the claims %s are successfully inserted for the tenant: %s", scope.getName(), Arrays.asList(scope.getClaim()), tenantId));
                return;
            }
            catch (DataAccessException e) {
                String errorMessage = "Error while persisting scopes for the tenant: " + tenantId;
                throw new IdentityOAuth2Exception(errorMessage, e);
            }
        } else {
            log.warn((Object)String.format("Scope %s already exist in tenant %s.", scope.getName(), tenantId));
            throw new IdentityOAuth2ClientException(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_CONFLICT_REQUEST_EXISTING_SCOPE.getCode(), String.format(Oauth2ScopeConstants.ErrorMessages.ERROR_CODE_CONFLICT_REQUEST_EXISTING_SCOPE.getMessage(), scope.getName()));
        }
    }

    @Override
    public List<ScopeDTO> getScopes(int tenantId) throws IdentityOAuth2Exception {
        ArrayList<ScopeDTO> oidcScopeClaimList;
        String sql = "SELECT FILTEREDSCOPES.NAME, FILTEREDSCOPES.DISPLAY_NAME, FILTEREDSCOPES.DESCRIPTION, IDN_CLAIM.CLAIM_URI FROM (SELECT * FROM IDN_OAUTH2_SCOPE WHERE IDN_OAUTH2_SCOPE.TENANT_ID=? AND IDN_OAUTH2_SCOPE.SCOPE_TYPE=?) FILTEREDSCOPES LEFT JOIN IDN_OIDC_SCOPE_CLAIM_MAPPING ON IDN_OIDC_SCOPE_CLAIM_MAPPING.SCOPE_ID = FILTEREDSCOPES.SCOPE_ID LEFT JOIN IDN_CLAIM ON IDN_CLAIM.ID = IDN_OIDC_SCOPE_CLAIM_MAPPING.EXTERNAL_CLAIM_ID LEFT JOIN IDN_CLAIM_DIALECT ON IDN_CLAIM_DIALECT.ID = IDN_CLAIM.DIALECT_ID WHERE FILTEREDSCOPES.TENANT_ID = ? AND (IDN_CLAIM_DIALECT.TENANT_ID = ? AND IDN_CLAIM_DIALECT.DIALECT_URI = ?) OR (IDN_CLAIM_DIALECT.DIALECT_URI IS NULL AND IDN_CLAIM_DIALECT.TENANT_ID IS NULL)";
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            HashMap scopeClaimMap = new HashMap();
            jdbcTemplate.executeQuery(sql, (resultSet, i) -> {
                String scope = resultSet.getString(1);
                if (!scopeClaimMap.containsKey(scope)) {
                    ScopeDTO tempScopeDTO = new ScopeDTO(scope, resultSet.getString(2), resultSet.getString(3), new String[0]);
                    if (resultSet.getString(4) != null) {
                        tempScopeDTO.setClaim(new String[]{resultSet.getString(4)});
                    }
                    scopeClaimMap.put(scope, tempScopeDTO);
                } else if (resultSet.getString(4) != null) {
                    ScopeDTO tempScope = (ScopeDTO)scopeClaimMap.get(scope);
                    tempScope.addNewClaimToExistingClaims(resultSet.getString(4));
                    scopeClaimMap.replace(scope, tempScope);
                }
                return null;
            }, preparedStatement -> {
                preparedStatement.setInt(1, tenantId);
                preparedStatement.setString(2, "OIDC");
                preparedStatement.setInt(3, tenantId);
                preparedStatement.setInt(4, tenantId);
                preparedStatement.setString(5, OIDC_DIALECT_URI);
            });
            oidcScopeClaimList = new ArrayList<ScopeDTO>(scopeClaimMap.values());
        }
        catch (DataAccessException e) {
            String errorMessage = "Error occured while loading scopes claims mapping.";
            throw new IdentityOAuth2Exception(errorMessage, e);
        }
        return oidcScopeClaimList;
    }

    @Override
    public List<String> getScopeNames(int tenantId) throws IdentityOAuth2Exception {
        String sql = "SELECT NAME FROM IDN_OAUTH2_SCOPE WHERE TENANT_ID=? AND SCOPE_TYPE=?";
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            List scopeList = jdbcTemplate.executeQuery(sql, (resultSet, i) -> resultSet.getString(1), preparedStatement -> {
                preparedStatement.setInt(1, tenantId);
                preparedStatement.setString(2, "OIDC");
            });
            if (log.isDebugEnabled()) {
                log.debug((Object)("The scopes: " + String.join((CharSequence)",", scopeList) + " are successfully loaded for the tenant: " + tenantId));
            }
            return scopeList;
        }
        catch (DataAccessException e) {
            String errorMessage = "Error while loading OIDC scopes.";
            throw new IdentityOAuth2Exception(errorMessage, e);
        }
    }

    @Override
    public ScopeDTO getClaims(String scope, int tenantId) throws IdentityOAuth2Exception {
        String sql = "SELECT CLAIM_URI  FROM IDN_OAUTH2_SCOPE LEFT JOIN IDN_OIDC_SCOPE_CLAIM_MAPPING  ON IDN_OIDC_SCOPE_CLAIM_MAPPING.SCOPE_ID = IDN_OAUTH2_SCOPE.SCOPE_ID LEFT JOIN IDN_CLAIM ON IDN_CLAIM.ID =IDN_OIDC_SCOPE_CLAIM_MAPPING.EXTERNAL_CLAIM_ID WHERE IDN_OAUTH2_SCOPE.NAME=? AND IDN_OAUTH2_SCOPE.TENANT_ID=?";
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        ScopeDTO scopeDTO = new ScopeDTO();
        try {
            List claimsList = jdbcTemplate.executeQuery(sql, (resultSet, i) -> resultSet.getString(1), preparedStatement -> {
                preparedStatement.setString(1, scope);
                preparedStatement.setInt(2, tenantId);
            });
            scopeDTO.setName(scope);
            String[] claimsArr = new String[claimsList.size()];
            scopeDTO.setClaim(claimsList.toArray(claimsArr));
        }
        catch (DataAccessException e) {
            String errorMessage = "Error while loading OIDC claims for the scope: " + scope;
            throw new IdentityOAuth2Exception(errorMessage, e);
        }
        return scopeDTO;
    }

    @Override
    public void deleteScope(String scope, int tenantId) throws IdentityOAuth2Exception {
        block4: {
            JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
            try {
                if (this.isScopeExist(scope, tenantId)) {
                    jdbcTemplate.executeUpdate("DELETE FROM IDN_OAUTH2_SCOPE WHERE NAME=? AND TENANT_ID=? AND SCOPE_TYPE=?", preparedStatement -> {
                        preparedStatement.setString(1, scope);
                        preparedStatement.setInt(2, tenantId);
                        preparedStatement.setString(3, "OIDC");
                    });
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("The scope: %s in the tenant: %s is successfully deleted.", scope, tenantId));
                    }
                    break block4;
                }
                String errorMessage = "The scope: " + scope + " does not exist to delete.";
                throw new IdentityOAuth2Exception(errorMessage);
            }
            catch (DataAccessException e) {
                throw new IdentityOAuth2Exception("Error while deleting the scope: " + scope + " and related claims.", e);
            }
        }
    }

    @Override
    @Deprecated
    public void updateScope(String scope, int tenantId, List<String> addClaims, List<String> deleteClaims) throws IdentityOAuth2Exception {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        int scopeClaimMappingId = -1;
        try {
            if (CollectionUtils.isNotEmpty(addClaims)) {
                int scopeId = this.getScopeId(scope, tenantId);
                this.addClaimsByScope(scopeId, tenantId, addClaims, jdbcTemplate, scopeClaimMappingId);
            }
            if (CollectionUtils.isNotEmpty(deleteClaims)) {
                this.deleteClaimsByScope(scope, tenantId, deleteClaims, jdbcTemplate, scopeClaimMappingId);
            }
        }
        catch (TransactionException e) {
            String errorMsg = "Error while inserting new claims for the scope: " + scope;
            throw new IdentityOAuth2Exception(errorMsg, e);
        }
    }

    @Override
    public void updateScope(ScopeDTO scope, int tenantId) throws IdentityOAuth2Exception {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            int scopeId = this.getScopeId(scope.getName(), tenantId);
            if (scopeId != -1) {
                this.updateScopeDetails(scope, jdbcTemplate, scopeId);
                this.deleteClaimMappings(scopeId, jdbcTemplate);
                HashSet<String> claimsSet = new HashSet<String>(Arrays.asList(scope.getClaim()));
                this.insertClaims(tenantId, scopeId, claimsSet);
            }
        }
        catch (DataAccessException e) {
            throw new IdentityOAuth2Exception("Error while updating the scope: " + scope.getName() + " and it's related claims.", e);
        }
    }

    private void deleteClaimMappings(int scopeId, JdbcTemplate jdbcTemplate) throws DataAccessException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting existing OIDC claim mapping of scopeID: " + scopeId));
        }
        jdbcTemplate.executeUpdate("DELETE FROM IDN_OIDC_SCOPE_CLAIM_MAPPING WHERE SCOPE_ID=?", preparedStatement -> preparedStatement.setInt(1, scopeId));
    }

    private void addClaimsByScope(int scopeId, int tenantId, List<String> claims, JdbcTemplate jdbcTemplate, int scopeClaimMappingId) throws TransactionException {
        jdbcTemplate.withTransaction(template -> {
            template.executeBatchInsert("INSERT INTO IDN_OIDC_SCOPE_CLAIM_MAPPING (SCOPE_ID,EXTERNAL_CLAIM_ID) VALUES (?, ?)", preparedStatement -> {
                try {
                    for (String claim : claims) {
                        int claimId = this.loadOIDCClaimId(claim, tenantId);
                        preparedStatement.setInt(1, scopeId);
                        preparedStatement.setInt(2, claimId);
                        preparedStatement.addBatch();
                    }
                }
                catch (IdentityOAuth2Exception e) {
                    String errorMessage = "Error while fetching claims id. ";
                    log.error((Object)errorMessage, (Throwable)((Object)e));
                }
            }, (Object)scopeClaimMappingId);
            return null;
        });
    }

    private void deleteClaimsByScope(String scope, int tenantId, List<String> claims, JdbcTemplate jdbcTemplate, int scopeClaimMappingId) throws TransactionException {
        jdbcTemplate.withTransaction(template -> {
            template.executeBatchInsert("DELETE FROM IDN_OIDC_SCOPE_CLAIM_MAPPING WHERE EXTERNAL_CLAIM_ID IN (SELECT IDN_SCM.EXTERNAL_CLAIM_ID FROM (SELECT * FROM IDN_OIDC_SCOPE_CLAIM_MAPPING) IDN_SCM LEFT JOIN IDN_OAUTH2_SCOPE ON IDN_SCM.SCOPE_ID = IDN_OAUTH2_SCOPE.SCOPE_ID LEFT JOIN IDN_CLAIM ON IDN_CLAIM.ID = IDN_SCM.EXTERNAL_CLAIM_ID LEFT JOIN IDN_CLAIM_DIALECT ON IDN_CLAIM_DIALECT.ID = IDN_CLAIM.DIALECT_ID WHERE IDN_OAUTH2_SCOPE.NAME =? AND IDN_CLAIM.CLAIM_URI =? AND IDN_OAUTH2_SCOPE.TENANT_ID =? AND DIALECT_URI = 'http://wso2.org/oidc/claim') AND SCOPE_ID IN (SELECT IDN_OAUTH2_SCOPE.SCOPE_ID FROM IDN_OAUTH2_SCOPE WHERE NAME =? AND SCOPE_TYPE=?)", preparedStatement -> {
                for (String claim : claims) {
                    preparedStatement.setString(1, scope);
                    preparedStatement.setString(2, claim);
                    preparedStatement.setInt(3, tenantId);
                    preparedStatement.setString(4, scope);
                    preparedStatement.setString(5, "OIDC");
                    preparedStatement.addBatch();
                }
            }, (Object)scopeClaimMappingId);
            return null;
        });
    }

    @Override
    public boolean hasScopesPopulated(int tenantId) throws IdentityOAuth2Exception {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            Integer id = (Integer)jdbcTemplate.withTransaction(template -> (Integer)template.fetchSingleRecord("SELECT COUNT(SCOPE_ID) FROM IDN_OAUTH2_SCOPE WHERE TENANT_ID=? AND SCOPE_TYPE=?", (resultSet, rowNumber) -> resultSet.getInt(1), preparedStatement -> {
                preparedStatement.setInt(1, tenantId);
                preparedStatement.setString(2, "OIDC");
            }));
            if (id == 0) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope id: " + id + "is returned for the tenant: " + tenantId));
            }
        }
        catch (TransactionException e) {
            String errorMessage = "Error while loading the top scope id for the tenant: " + tenantId;
            throw new IdentityOAuth2Exception(errorMessage, e);
        }
        return true;
    }

    @Override
    public boolean isScopeExist(String scope, int tenantId) throws IdentityOAuth2Exception {
        int scopeId = this.getScopeId(scope, tenantId);
        return scopeId != -1;
    }

    @Override
    public ScopeDTO getScope(String scopeName, int tenantId) throws IdentityOAuth2Exception {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        String sql = "SELECT FILTEREDSCOPE.NAME, FILTEREDSCOPE.DISPLAY_NAME, FILTEREDSCOPE.DESCRIPTION, IDN_CLAIM.CLAIM_URI FROM (SELECT * FROM IDN_OAUTH2_SCOPE WHERE IDN_OAUTH2_SCOPE.NAME=? AND IDN_OAUTH2_SCOPE.TENANT_ID=? AND IDN_OAUTH2_SCOPE.SCOPE_TYPE=?) FILTEREDSCOPE LEFT JOIN IDN_OIDC_SCOPE_CLAIM_MAPPING ON IDN_OIDC_SCOPE_CLAIM_MAPPING.SCOPE_ID = FILTEREDSCOPE.SCOPE_ID LEFT JOIN IDN_CLAIM ON IDN_CLAIM.ID = IDN_OIDC_SCOPE_CLAIM_MAPPING.EXTERNAL_CLAIM_ID LEFT JOIN IDN_CLAIM_DIALECT ON IDN_CLAIM_DIALECT.ID = IDN_CLAIM.DIALECT_ID WHERE FILTEREDSCOPE.TENANT_ID = ? AND (IDN_CLAIM_DIALECT.TENANT_ID = ? AND IDN_CLAIM_DIALECT.DIALECT_URI = ?) OR (IDN_CLAIM_DIALECT.DIALECT_URI IS NULL AND IDN_CLAIM_DIALECT.TENANT_ID IS NULL)";
        try {
            HashMap tempScopeMap = new HashMap();
            jdbcTemplate.executeQuery(sql, (resultSet, i) -> {
                if (!tempScopeMap.containsKey(resultSet.getString(1))) {
                    ScopeDTO scopeDTO = new ScopeDTO(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), new String[0]);
                    if (resultSet.getString(4) != null) {
                        scopeDTO.setClaim(new String[]{resultSet.getString(4)});
                    }
                    tempScopeMap.put(resultSet.getString(1), scopeDTO);
                } else if (resultSet.getString(4) != null) {
                    ScopeDTO tempScope = (ScopeDTO)tempScopeMap.get(resultSet.getString(1));
                    tempScope.addNewClaimToExistingClaims(resultSet.getString(4));
                    tempScopeMap.replace(resultSet.getString(1), tempScope);
                }
                return null;
            }, preparedStatement -> {
                preparedStatement.setString(1, scopeName);
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, "OIDC");
                preparedStatement.setInt(4, tenantId);
                preparedStatement.setInt(5, tenantId);
                preparedStatement.setString(6, OIDC_DIALECT_URI);
            });
            return (ScopeDTO)tempScopeMap.get(scopeName);
        }
        catch (DataAccessException e) {
            String errorMessage = "Error while fetching scope details for scope: " + scopeName;
            throw new IdentityOAuth2Exception(errorMessage, e);
        }
    }

    private int getScopeId(String scope, int tenantId) throws IdentityOAuth2Exception {
        Integer scopeId;
        try {
            JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
            scopeId = (Integer)jdbcTemplate.withTransaction(template -> (Integer)template.fetchSingleRecord("SELECT SCOPE_ID FROM IDN_OAUTH2_SCOPE WHERE NAME=? AND TENANT_ID=? AND SCOPE_TYPE=?", (resultSet, rowNumber) -> resultSet.getInt(1), preparedStatement -> {
                preparedStatement.setString(1, scope);
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, "OIDC");
            }));
            if (scopeId == null) {
                scopeId = -1;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope id: " + scopeId + "is returned for the tenant: " + tenantId + "and scope: " + scope));
            }
        }
        catch (TransactionException e) {
            String errorMessage = "Error fetching data for oidc scope: " + scope;
            throw new IdentityOAuth2Exception(errorMessage, e);
        }
        return scopeId;
    }

    private boolean isScopeExist(String scope, int tenantId, boolean includeOAuth2Scopes) throws IdentityOAuth2Exception {
        int scopeId = includeOAuth2Scopes ? this.getScopeIdWithoutScopeType(scope, tenantId) : this.getScopeId(scope, tenantId);
        return scopeId != -1;
    }

    private int getScopeIdWithoutScopeType(String scope, int tenantId) throws IdentityOAuth2Exception {
        Integer scopeId;
        try {
            JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
            scopeId = (Integer)jdbcTemplate.withTransaction(template -> (Integer)template.fetchSingleRecord("SELECT SCOPE_ID FROM IDN_OAUTH2_SCOPE WHERE NAME=? AND TENANT_ID=?", (resultSet, rowNumber) -> resultSet.getInt(1), preparedStatement -> {
                preparedStatement.setString(1, scope);
                preparedStatement.setInt(2, tenantId);
            }));
            if (scopeId == null) {
                scopeId = -1;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope id: " + scopeId + "is returned for the tenant: " + tenantId + "and scope: " + scope));
            }
        }
        catch (TransactionException e) {
            String errorMessage = "Error while obtaining ID of scope: " + scope;
            throw new IdentityOAuth2Exception(errorMessage, e);
        }
        return scopeId;
    }

    private int loadOIDCClaimId(String claim, int tenantId) throws IdentityOAuth2Exception {
        Integer oidcClaimId;
        try {
            JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
            oidcClaimId = (Integer)jdbcTemplate.withTransaction(template -> (Integer)template.fetchSingleRecord("SELECT ID FROM IDN_CLAIM WHERE CLAIM_URI = ? AND TENANT_ID = ? AND DIALECT_ID = (SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI = ? AND TENANT_ID = ?)", (resultSet, rowNumber) -> resultSet.getInt(1), preparedStatement -> {
                preparedStatement.setString(1, claim);
                preparedStatement.setInt(2, tenantId);
                preparedStatement.setString(3, OIDC_DIALECT_URI);
                preparedStatement.setInt(4, tenantId);
            }));
            if (oidcClaimId == null) {
                oidcClaimId = -1;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Claim id: " + oidcClaimId + "is returned."));
            }
        }
        catch (TransactionException e) {
            String errorMessage = "Error fetching data for oidc scope: " + claim;
            throw new IdentityOAuth2Exception(errorMessage, e);
        }
        return oidcClaimId;
    }

    private void insertClaims(int tenantId, int scopeId, Set<String> claimsList) throws IdentityOAuth2Exception {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        int scopeClaimMappingId = -1;
        try {
            jdbcTemplate.withTransaction(template -> {
                template.executeBatchInsert("INSERT INTO IDN_OIDC_SCOPE_CLAIM_MAPPING (SCOPE_ID, EXTERNAL_CLAIM_ID) SELECT ?,IDN_CLAIM.ID FROM IDN_CLAIM LEFT JOIN IDN_CLAIM_DIALECT ON IDN_CLAIM_DIALECT.ID = IDN_CLAIM.DIALECT_ID WHERE CLAIM_URI=? AND IDN_CLAIM_DIALECT.DIALECT_URI='http://wso2.org/oidc/claim' AND IDN_CLAIM_DIALECT.TENANT_ID=?", preparedStatement -> {
                    if (CollectionUtils.isNotEmpty((Collection)claimsList)) {
                        for (String claim : claimsList) {
                            preparedStatement.setInt(1, scopeId);
                            preparedStatement.setString(2, claim);
                            preparedStatement.setInt(3, tenantId);
                            preparedStatement.addBatch();
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Claim value :" + claim + " is added to the batch."));
                        }
                    }
                }, (Object)scopeClaimMappingId);
                return null;
            });
        }
        catch (TransactionException e) {
            String errorMessage = String.format("Error when storing oidc claims for scope ID: %s for tenant: %s", scopeId, tenantId);
            throw new IdentityOAuth2Exception(errorMessage, e);
        }
    }

    private void updateScopeDetails(ScopeDTO updatedScope, JdbcTemplate jdbcTemplate, int scopeId) throws DataAccessException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Update scope details on IDN_OAUTH2_SCOPE scope table for scope: " + updatedScope.getName()));
        }
        jdbcTemplate.executeUpdate("UPDATE IDN_OAUTH2_SCOPE SET DISPLAY_NAME=?, DESCRIPTION=? WHERE SCOPE_ID=?", preparedStatement -> {
            preparedStatement.setString(1, updatedScope.getDisplayName());
            preparedStatement.setString(2, updatedScope.getDescription());
            preparedStatement.setInt(3, scopeId);
        });
    }
}

