/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.AuthorizationCodeDAOImpl;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.openidconnect.dao.RequestObjectDAO;
import org.wso2.carbon.identity.openidconnect.model.RequestedClaim;
import org.wso2.carbon.utils.DBUtils;

public class RequestObjectDAOImpl
implements RequestObjectDAO {
    private static final String ID = "ID";
    private static final Log log = LogFactory.getLog(AuthorizationCodeDAOImpl.class);

    @Override
    public void insertRequestObjectData(String consumerKey, String sessionDataKey, List<List<RequestedClaim>> claims) throws IdentityOAuth2Exception {
        Connection connection;
        ResultSet rs;
        PreparedStatement prepStmt;
        block8: {
            prepStmt = null;
            rs = null;
            String sqlStmt = "INSERT INTO IDN_OIDC_REQ_OBJECT_REFERENCE (CONSUMER_KEY_ID, SESSION_DATA_KEY) VALUES ((SELECT ID FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?),?)";
            connection = null;
            try {
                connection = IdentityDatabaseUtil.getDBConnection();
                String dbProductName = connection.getMetaData().getDatabaseProductName();
                prepStmt = connection.prepareStatement(sqlStmt, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)ID)});
                prepStmt.setString(1, consumerKey);
                prepStmt.setString(2, sessionDataKey);
                prepStmt.executeUpdate();
                int requestObjectId = -1;
                rs = prepStmt.getGeneratedKeys();
                if (rs.next()) {
                    requestObjectId = rs.getInt(1);
                } else {
                    log.warn((Object)("Unable to persist Request Object reference for : " + sessionDataKey));
                }
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
                if (requestObjectId == -1) break block8;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully stored the Request Object reference: " + requestObjectId + " for sessionDataKey: " + sessionDataKey));
                }
                if (CollectionUtils.isNotEmpty(claims)) {
                    this.insertRequestObjectClaims(requestObjectId, claims, connection);
                }
            }
            catch (SQLException e) {
                try {
                    IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                    String errorMessage = "Error when storing the request object reference";
                    log.error((Object)errorMessage, (Throwable)e);
                    throw new IdentityOAuth2Exception(errorMessage, e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, prepStmt);
                    throw throwable;
                }
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
    }

    @Override
    public void updateRequestObjectReferencebyCodeId(String sessionDataKey, String codeId) throws IdentityOAuth2Exception {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
            String sql = "UPDATE IDN_OIDC_REQ_OBJECT_REFERENCE SET CODE_ID=?,TOKEN_ID=? WHERE SESSION_DATA_KEY=?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, codeId);
            ps.setString(2, null);
            ps.setString(3, sessionDataKey);
            ps.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String errorMsg = "Can not update code id or the access token id of the table .IDN_OIDC_REQ_OBJECT_REFERENCE";
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
    }

    @Override
    public void updateRequestObjectReferencebyTokenId(String sessionDataKey, String accessTokenId) throws IdentityOAuth2Exception {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
            String sql = "UPDATE IDN_OIDC_REQ_OBJECT_REFERENCE SET CODE_ID=?,TOKEN_ID=? WHERE SESSION_DATA_KEY=?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, null);
            ps.setString(2, accessTokenId);
            ps.setString(3, sessionDataKey);
            ps.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String errorMsg = "Can not update code id or the access token id of the table .IDN_OIDC_REQ_OBJECT_REFERENCE";
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
    }

    private void insertRequestObjectClaims(int requestObjectId, List<List<RequestedClaim>> claims, Connection connection) throws IdentityOAuth2Exception {
        String sqlStmt = "INSERT INTO IDN_OIDC_REQ_OBJECT_CLAIMS (REQ_OBJECT_ID,CLAIM_ATTRIBUTE, ESSENTIAL, VALUE, IS_USERINFO) VALUES (?, ?, ?, ?, ?)";
        PreparedStatement prepStmt = null;
        HashMap<Integer, List<String>> claimValues = new HashMap<Integer, List<String>>();
        try {
            connection.setAutoCommit(false);
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            prepStmt = connection.prepareStatement(sqlStmt, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)ID)});
            for (List<RequestedClaim> list : claims) {
                if (CollectionUtils.isNotEmpty(list)) {
                    for (RequestedClaim claim : list) {
                        prepStmt.setInt(1, requestObjectId);
                        prepStmt.setString(2, claim.getName());
                        prepStmt.setString(3, claim.isEssential() ? "1" : "0");
                        prepStmt.setString(4, claim.getValue());
                        if ("userinfo".equals(claim.getType())) {
                            prepStmt.setString(5, "1");
                        } else if ("id_token".equals(claim.getType())) {
                            prepStmt.setString(5, "0");
                        }
                        prepStmt.addBatch();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Claim :" + claim.getName() + "is added to the batch against :" + claim.getType()));
                    }
                }
                prepStmt.executeBatch();
            }
            Map<Integer, String> insertedRequestObjectClaims = this.getInsertedRequestObjectClaims(connection, requestObjectId);
            if (MapUtils.isNotEmpty(insertedRequestObjectClaims)) {
                for (Map.Entry entry : insertedRequestObjectClaims.entrySet()) {
                    for (List<RequestedClaim> list : claims) {
                        if (!CollectionUtils.isNotEmpty(list)) continue;
                        for (RequestedClaim claim : list) {
                            if (!claim.getName().equals(entry.getValue())) continue;
                            claimValues.put((Integer)entry.getKey(), claim.getValues());
                        }
                    }
                }
                if (MapUtils.isNotEmpty(claimValues)) {
                    this.insertRequestObjectClaimValues(claimValues, connection);
                }
            }
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    String errorMessage = "Rollback error when storing the request object claims.";
                    throw new IdentityOAuth2Exception(errorMessage, e);
                }
                String errorMessage = "Error when storing the request object claims.";
                log.error((Object)errorMessage, (Throwable)e);
                throw new IdentityOAuth2Exception(errorMessage, e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement(prepStmt);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
    }

    private Map<Integer, String> getInsertedRequestObjectClaims(Connection connection, int requestObjectId) throws IdentityOAuth2Exception {
        HashMap<Integer, String> insertedRequestObjectClaims = new HashMap<Integer, String>();
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT ID, CLAIM_ATTRIBUTE FROM IDN_OIDC_REQ_OBJECT_CLAIMS WHERE REQ_OBJECT_ID=? ";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setInt(1, requestObjectId);
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                insertedRequestObjectClaims.put(resultSet.getInt(1), resultSet.getString(2));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error when retrieving inserted claim attributes details.", (Throwable)e);
            throw new IdentityOAuth2Exception("Error when storing the request object claims", e);
        }
        return insertedRequestObjectClaims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRequestObjectClaimValues(Map<Integer, List<String>> claimValues, Connection connection) throws IdentityOAuth2Exception, SQLException {
        String sqlStmt = "INSERT INTO IDN_OIDC_REQ_OBJ_CLAIM_VALUES (REQ_OBJECT_CLAIMS_ID,CLAIM_VALUES) VALUES (?, ?)";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement(sqlStmt);
            for (Map.Entry<Integer, List<String>> entry : claimValues.entrySet()) {
                List<String> claimValuesList = entry.getValue();
                if (!CollectionUtils.isNotEmpty(claimValuesList)) continue;
                for (String value : claimValuesList) {
                    prepStmt.setInt(1, entry.getKey());
                    prepStmt.setString(2, value);
                    prepStmt.addBatch();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Claim value :" + value + " is added to the batch."));
                }
            }
            prepStmt.executeBatch();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    @Override
    public List<RequestedClaim> getRequestedClaimsbySessionDataKey(String sessionDataKey, boolean isUserInfo) throws IdentityOAuth2Exception {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        ArrayList<RequestedClaim> essentialClaims = new ArrayList<RequestedClaim>();
        try {
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            String sql = "SELECT CLAIM_ATTRIBUTE, ESSENTIAL, VALUE FROM IDN_OIDC_REQ_OBJECT_CLAIMS LEFT JOIN IDN_OIDC_REQ_OBJECT_REFERENCE ON IDN_OIDC_REQ_OBJECT_CLAIMS.REQ_OBJECT_ID = IDN_OIDC_REQ_OBJECT_REFERENCE.ID WHERE SESSION_DATA_KEY=? AND IS_USERINFO=?";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, sessionDataKey);
            prepStmt.setString(2, isUserInfo ? "1" : "0");
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                RequestedClaim requestedClaim = new RequestedClaim();
                requestedClaim.setName(resultSet.getString(1));
                requestedClaim.setEssential(!"0".equals(resultSet.getString(2)));
                requestedClaim.setValue(resultSet.getString(3));
                essentialClaims.add(requestedClaim);
            }
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving request object by session data key: " + sessionDataKey + ", isUserInfo: " + isUserInfo;
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return essentialClaims;
    }

    @Override
    public List<RequestedClaim> getRequestedClaims(String token, boolean isUserInfo) throws IdentityOAuth2Exception {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        ArrayList<RequestedClaim> essentialClaims = new ArrayList<RequestedClaim>();
        try {
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            String sql = "SELECT CLAIM_ATTRIBUTE, ESSENTIAL, VALUE  FROM IDN_OIDC_REQ_OBJECT_CLAIMS LEFT JOIN IDN_OIDC_REQ_OBJECT_REFERENCE ON IDN_OIDC_REQ_OBJECT_CLAIMS.REQ_OBJECT_ID = IDN_OIDC_REQ_OBJECT_REFERENCE.ID WHERE TOKEN_ID=? AND IS_USERINFO=? ";
            String tokenId = OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().getTokenIdByAccessToken(token);
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, tokenId);
            prepStmt.setString(2, isUserInfo ? "1" : "0");
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                RequestedClaim requestedClaim = new RequestedClaim();
                requestedClaim.setName(resultSet.getString(1));
                requestedClaim.setEssential(!"0".equals(resultSet.getString(2)));
                requestedClaim.setValue(resultSet.getString(3));
                essentialClaims.add(requestedClaim);
            }
        }
        catch (SQLException e) {
            try {
                String errorMsg = "Error occurred while retrieving request object.";
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return essentialClaims;
    }

    @Override
    public void refreshRequestObjectReference(String oldAccessTokenId, String newAccessTokenId) throws IdentityOAuth2Exception {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
            String sql = "UPDATE IDN_OIDC_REQ_OBJECT_REFERENCE SET TOKEN_ID=? WHERE TOKEN_ID=?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, newAccessTokenId);
            ps.setString(2, oldAccessTokenId);
            ps.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String errorMsg = "Can not update refreshed token id of the table .IDN_OIDC_REQ_OBJECT_REFERENCE";
                throw new IdentityOAuth2Exception(errorMsg, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateRequestObjectReferenceCodeToToken(String codeId, String tokenId) throws IdentityOAuth2Exception {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
            this.deleteRequestObjectReferenceforCode(tokenId);
            String sql = "UPDATE IDN_OIDC_REQ_OBJECT_REFERENCE SET TOKEN_ID=? WHERE CODE_ID=?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tokenId);
            ps.setString(2, codeId);
            ps.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String errorMsg = "Can not update token id for code id: " + codeId;
                throw new IdentityOAuth2Exception(errorMsg, e);
                catch (IdentityOAuthAdminException e2) {
                    errorMsg = "Can not delete existing entry for the same token id" + tokenId;
                    throw new IdentityOAuth2Exception(errorMsg, (Throwable)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, ps);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)ps);
    }

    private void deleteRequestObjectReferenceforCode(String tokenId) throws IdentityOAuthAdminException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_OIDC_REQ_OBJECT_REFERENCE WHERE TOKEN_ID = ?");){
                prepStmt.setString(1, tokenId);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw OAuthUtil.handleError("Can not delete existing entry for the same token id" + tokenId, e1);
            }
        }
        catch (SQLException e) {
            throw OAuthUtil.handleError("Can not delete existing entry for the same token id" + tokenId, e);
        }
    }

    @Override
    public void deleteRequestObjectReferenceByTokenId(String tokenId) throws IdentityOAuthAdminException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_OIDC_REQ_OBJECT_REFERENCE WHERE TOKEN_ID = ?");){
                prepStmt.setString(1, tokenId);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw OAuthUtil.handleError("Error when executing the SQL : DELETE FROM IDN_OIDC_REQ_OBJECT_REFERENCE WHERE TOKEN_ID = ?", e1);
            }
        }
        catch (SQLException e) {
            throw OAuthUtil.handleError("Error when executing the SQL : DELETE FROM IDN_OIDC_REQ_OBJECT_REFERENCE WHERE TOKEN_ID = ?", e);
        }
    }

    @Override
    public void deleteRequestObjectReferenceByCode(String codeId) throws IdentityOAuthAdminException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement prepStmt = connection.prepareStatement("DELETE FROM IDN_OIDC_REQ_OBJECT_REFERENCE WHERE CODE_ID = ?");){
                prepStmt.setString(1, codeId);
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw OAuthUtil.handleError("Error when executing the SQL : DELETE FROM IDN_OIDC_REQ_OBJECT_REFERENCE WHERE CODE_ID = ?", e1);
            }
        }
        catch (SQLException e) {
            throw OAuthUtil.handleError("Error when executing the SQL : DELETE FROM IDN_OIDC_REQ_OBJECT_REFERENCE WHERE CODE_ID = ?", e);
        }
    }
}

