/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect.dao;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.dto.ScopeDTO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.openidconnect.cache.OIDCScopeClaimCache;
import org.wso2.carbon.identity.openidconnect.cache.OIDCScopeClaimCacheEntry;
import org.wso2.carbon.identity.openidconnect.dao.ScopeClaimMappingDAO;
import org.wso2.carbon.identity.openidconnect.dao.ScopeClaimMappingDAOImpl;

public class CacheBackedScopeClaimMappingDAOImpl
extends ScopeClaimMappingDAOImpl {
    private static final Log log = LogFactory.getLog(CacheBackedScopeClaimMappingDAOImpl.class);
    private OIDCScopeClaimCache oidcScopeClaimCache = OIDCScopeClaimCache.getInstance();
    private ScopeClaimMappingDAO defaultScopeClaimMappingDAO = new ScopeClaimMappingDAOImpl();

    @Override
    public void addScopes(int tenantId, List<ScopeDTO> scopeClaimsMap) throws IdentityOAuth2Exception {
        super.addScopes(tenantId, scopeClaimsMap);
        OIDCScopeClaimCacheEntry oidcScopeClaimCacheEntry = new OIDCScopeClaimCacheEntry();
        oidcScopeClaimCacheEntry.setScopeClaimMapping(scopeClaimsMap);
        this.oidcScopeClaimCache.addScopeClaimMap(tenantId, oidcScopeClaimCacheEntry);
        if (log.isDebugEnabled()) {
            log.debug((Object)("The cache oidcScopeClaimCache is cleared for the tenant : " + tenantId));
        }
    }

    @Override
    @Deprecated
    public void addScope(int tenantId, String scope, String[] claimsList) throws IdentityOAuth2Exception {
        this.oidcScopeClaimCache.clearScopeClaimMap(tenantId);
        super.addScope(tenantId, scope, claimsList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("The cache oidcScopeClaimCache is cleared for the tenant : " + tenantId));
        }
    }

    @Override
    public void addScope(ScopeDTO scope, int tenantId) throws IdentityOAuth2Exception {
        this.oidcScopeClaimCache.clearScopeClaimMap(tenantId);
        super.addScope(scope, tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("The cache oidcScopeClaimCache is cleared for the tenant : " + tenantId));
        }
    }

    @Override
    public List<ScopeDTO> getScopes(int tenantId) throws IdentityOAuth2Exception {
        OIDCScopeClaimCacheEntry oidcScopeClaimCacheEntry = this.oidcScopeClaimCache.getScopeClaimMap(tenantId);
        oidcScopeClaimCacheEntry = this.loadOIDCScopeClaims(tenantId, oidcScopeClaimCacheEntry);
        return oidcScopeClaimCacheEntry.getScopeClaimMapping();
    }

    @Override
    public void deleteScope(String scope, int tenantId) throws IdentityOAuth2Exception {
        super.deleteScope(scope, tenantId);
        this.oidcScopeClaimCache.clearScopeClaimMap(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("OIDC scope claims mapping deleted from the oidcScopeClaimCache for tenant: " + tenantId));
        }
    }

    @Override
    @Deprecated
    public void updateScope(String scope, int tenantId, List<String> addClaims, List<String> deleteClaims) throws IdentityOAuth2Exception {
        super.updateScope(scope, tenantId, addClaims, deleteClaims);
        this.oidcScopeClaimCache.clearScopeClaimMap(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("The cache oidcScopeClaimCache is cleared for the tenant : " + tenantId));
        }
    }

    @Override
    public void updateScope(ScopeDTO scope, int tenantId) throws IdentityOAuth2Exception {
        super.updateScope(scope, tenantId);
        this.oidcScopeClaimCache.clearScopeClaimMap(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("The cache oidcScopeClaimCache is cleared for the tenant : " + tenantId));
        }
    }

    @Override
    public List<String> getScopeNames(int tenantId) throws IdentityOAuth2Exception {
        OIDCScopeClaimCacheEntry oidcScopeClaimCacheEntry = this.oidcScopeClaimCache.getScopeClaimMap(tenantId);
        oidcScopeClaimCacheEntry = this.loadOIDCScopeClaims(tenantId, oidcScopeClaimCacheEntry);
        ArrayList<String> scopes = new ArrayList<String>();
        for (ScopeDTO scopeDTO : oidcScopeClaimCacheEntry.getScopeClaimMapping()) {
            scopes.add(scopeDTO.getName());
        }
        return scopes;
    }

    @Override
    public ScopeDTO getClaims(String scope, int tenantId) throws IdentityOAuth2Exception {
        OIDCScopeClaimCacheEntry oidcScopeClaimCacheEntry = this.oidcScopeClaimCache.getScopeClaimMap(tenantId);
        oidcScopeClaimCacheEntry = this.loadOIDCScopeClaims(tenantId, oidcScopeClaimCacheEntry);
        ScopeDTO scopeDTO = new ScopeDTO();
        for (ScopeDTO scopeObj : oidcScopeClaimCacheEntry.getScopeClaimMapping()) {
            if (!scope.equals(scopeObj.getName()) || scopeObj.getClaim() == null) continue;
            scopeDTO = scopeObj;
        }
        return scopeDTO;
    }

    private OIDCScopeClaimCacheEntry loadOIDCScopeClaims(int tenantId, OIDCScopeClaimCacheEntry oidcScopeClaimCacheEntry) throws IdentityOAuth2Exception {
        if (oidcScopeClaimCacheEntry == null || oidcScopeClaimCacheEntry.getScopeClaimMapping().size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache miss for OIDC scopes claims mapping for tenant: " + tenantId));
            }
            oidcScopeClaimCacheEntry = new OIDCScopeClaimCacheEntry();
            List<ScopeDTO> scopeClaims = this.defaultScopeClaimMappingDAO.getScopes(tenantId);
            oidcScopeClaimCacheEntry.setScopeClaimMapping(scopeClaims);
            this.oidcScopeClaimCache.addScopeClaimMap(tenantId, oidcScopeClaimCacheEntry);
            if (log.isDebugEnabled()) {
                log.debug((Object)("OIDC scopes and mapped claims are loaded from the database and inserted to the cache for the tenant : " + tenantId));
            }
        }
        return oidcScopeClaimCacheEntry;
    }

    @Override
    public ScopeDTO getScope(String scopeName, int tenantId) throws IdentityOAuth2Exception {
        OIDCScopeClaimCacheEntry oidcScopeClaimCacheEntry = this.oidcScopeClaimCache.getScopeClaimMap(tenantId);
        if (oidcScopeClaimCacheEntry != null && oidcScopeClaimCacheEntry.getScopeClaimMapping().size() != 0) {
            for (ScopeDTO scopeObj : oidcScopeClaimCacheEntry.getScopeClaimMapping()) {
                if (!scopeName.equals(scopeObj.getName())) continue;
                return scopeObj;
            }
        }
        return super.getScope(scopeName, tenantId);
    }
}

