/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.text.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.RequestObjectException;
import org.wso2.carbon.identity.oauth2.model.OAuth2Parameters;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.openidconnect.RequestObjectBuilder;
import org.wso2.carbon.identity.openidconnect.model.RequestObject;

public class RequestParamRequestObjectBuilder
implements RequestObjectBuilder {
    private static final Log log = LogFactory.getLog(RequestParamRequestObjectBuilder.class);

    @Override
    public RequestObject buildRequestObject(String requestObjectParam, OAuth2Parameters oAuth2Parameters) throws RequestObjectException {
        RequestObject requestObject = new RequestObject();
        String requestObjectParamValue = requestObjectParam;
        if (this.isEncrypted(requestObjectParamValue) && StringUtils.isEmpty((String)(requestObjectParamValue = this.decrypt(requestObjectParamValue, oAuth2Parameters)))) {
            return requestObject;
        }
        this.setRequestObjectValues(requestObjectParamValue, requestObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request Object extracted from the request: " + requestObjectParam));
        }
        return requestObject;
    }

    @Override
    public String decrypt(String requestObject, OAuth2Parameters oAuth2Parameters) throws RequestObjectException {
        try {
            EncryptedJWT encryptedJWT = EncryptedJWT.parse((String)requestObject);
            RSAPrivateKey rsaPrivateKey = this.getRSAPrivateKey(oAuth2Parameters);
            RSADecrypter decrypter = new RSADecrypter((PrivateKey)rsaPrivateKey);
            encryptedJWT.decrypt((JWEDecrypter)decrypter);
            JWEObject jweObject = JWEObject.parse((String)requestObject);
            jweObject.decrypt((JWEDecrypter)decrypter);
            if (jweObject.getPayload() != null && jweObject.getPayload().toString().split("\\.").length == 3) {
                return jweObject.getPayload().toString();
            }
            return new PlainJWT(encryptedJWT.getJWTClaimsSet()).serialize();
        }
        catch (JOSEException | ParseException | IdentityOAuth2Exception e) {
            String errorMessage = "Failed to decrypt Request Object";
            if (log.isDebugEnabled()) {
                log.debug((Object)(errorMessage + " from " + requestObject), (Throwable)e);
            }
            throw new RequestObjectException("invalid_request", errorMessage);
        }
    }

    protected boolean isEncrypted(String requestObject) {
        return requestObject.split("\\.").length == 5;
    }

    protected RSAPrivateKey getRSAPrivateKey(OAuth2Parameters oAuth2Parameters) throws IdentityOAuth2Exception {
        String tenantDomain = this.getTenantDomainForDecryption(oAuth2Parameters);
        int tenantId = OAuth2Util.getTenantId(tenantDomain);
        Key key = OAuth2Util.getPrivateKey(tenantDomain, tenantId);
        return (RSAPrivateKey)key;
    }

    private String getTenantDomainForDecryption(OAuth2Parameters oAuth2Parameters) {
        if (StringUtils.isNotEmpty((String)oAuth2Parameters.getTenantDomain())) {
            return oAuth2Parameters.getTenantDomain();
        }
        return "super";
    }

    private void setRequestObjectValues(String requestObjectString, RequestObject requestObjectInstance) throws RequestObjectException {
        try {
            JOSEObject jwt = JOSEObject.parse((String)requestObjectString);
            if (jwt.getHeader().getAlgorithm() == null || jwt.getHeader().getAlgorithm().equals((Object)JWSAlgorithm.NONE)) {
                requestObjectInstance.setPlainJWT(PlainJWT.parse((String)requestObjectString));
            } else {
                requestObjectInstance.setSignedJWT(SignedJWT.parse((String)requestObjectString));
            }
        }
        catch (ParseException e) {
            String errorMessage = "No Valid JWT is found for the Request Object.";
            if (log.isDebugEnabled()) {
                log.debug((Object)(errorMessage + "Received Request Object: " + requestObjectString), (Throwable)e);
            }
            throw new RequestObjectException("invalid_request", errorMessage);
        }
    }
}

