/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ServiceProviderProperty;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.RequestObjectException;
import org.wso2.carbon.identity.oauth2.model.OAuth2Parameters;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.jwt.JWKSBasedJWTValidator;
import org.wso2.carbon.identity.openidconnect.RequestObjectValidator;
import org.wso2.carbon.identity.openidconnect.model.RequestObject;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class RequestObjectValidatorImpl
implements RequestObjectValidator {
    private static final String OIDC_IDP_ENTITY_ID = "IdPEntityId";
    private static final String OIDC_ID_TOKEN_ISSUER_ID = "OAuth.OpenIDConnect.IDTokenIssuerID";
    private static Log log = LogFactory.getLog(RequestObjectValidatorImpl.class);

    @Override
    public boolean isSigned(RequestObject requestObject) {
        return requestObject.getSignedJWT() != null;
    }

    @Override
    public boolean validateSignature(RequestObject requestObject, OAuth2Parameters oAuth2Parameters) throws RequestObjectException {
        boolean isVerified;
        SignedJWT jwt;
        Certificate certificate;
        block6: {
            certificate = null;
            jwt = requestObject.getSignedJWT();
            try {
                certificate = this.getCertificateForAlias(oAuth2Parameters.getTenantDomain(), oAuth2Parameters.getClientId());
            }
            catch (RequestObjectException e) {
                String message = "Error retrieving public certificate for service provider checking whether a jwks endpoint is configured for the service provider with client_id: " + oAuth2Parameters.getClientId();
                log.warn((Object)message);
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)message, (Throwable)((Object)e));
            }
        }
        if (certificate == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Public certificate not configured for Service Provider with client_id: " + oAuth2Parameters.getClientId() + " of tenantDomain: " + oAuth2Parameters.getTenantDomain() + ". Fetching the jwks endpoint for validating request object"));
            }
            String jwksUri = this.getJWKSEndpoint(oAuth2Parameters);
            isVerified = this.isSignatureVerified(jwt, jwksUri);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Public certificate configured for Service Provider with client_id: " + oAuth2Parameters.getClientId() + " of tenantDomain: " + oAuth2Parameters.getTenantDomain() + ". Using public certificate  for validating request object"));
            }
            isVerified = this.isSignatureVerified(jwt, certificate);
        }
        requestObject.setIsSignatureValid(isVerified);
        return isVerified;
    }

    private String getJWKSEndpoint(OAuth2Parameters oAuth2Parameters) throws RequestObjectException {
        ServiceProviderProperty[] spProperties;
        String jwksUri = "";
        try {
            spProperties = OAuth2Util.getServiceProvider(oAuth2Parameters.getClientId()).getSpProperties();
        }
        catch (IdentityOAuth2Exception e) {
            throw new RequestObjectException("Error while getting the service provider for client ID " + oAuth2Parameters.getClientId(), "server_error", (Throwable)((Object)e));
        }
        if (spProperties != null) {
            for (ServiceProviderProperty spProperty : spProperties) {
                if (!"jwksURI".equals(spProperty.getName())) continue;
                jwksUri = spProperty.getValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found jwks endpoint " + jwksUri + " for service provider with client id " + oAuth2Parameters.getClientId()));
                }
                break;
            }
        } else {
            return "";
        }
        return jwksUri;
    }

    protected boolean isSignatureVerified(SignedJWT signedJWT, String jwksUri) throws RequestObjectException {
        if (StringUtils.isNotBlank((String)jwksUri)) {
            String jwtString = signedJWT.getParsedString();
            String alg = signedJWT.getHeader().getAlgorithm().getName();
            try {
                return new JWKSBasedJWTValidator().validateSignature(jwtString, jwksUri, alg, (Map<String, Object>)MapUtils.EMPTY_MAP);
            }
            catch (IdentityOAuth2Exception e) {
                String errorMessage = "Error occurred while validating request object signature using jwks endpoint";
                throw new RequestObjectException(errorMessage, "server_error", (Throwable)((Object)e));
            }
        }
        return false;
    }

    @Override
    public boolean validateRequestObject(RequestObject requestObject, OAuth2Parameters oAuth2Parameters) throws RequestObjectException {
        if (!this.validateClientIdAndResponseType(requestObject, oAuth2Parameters)) {
            return false;
        }
        if (!this.checkExpirationTime(requestObject)) {
            return false;
        }
        if (!this.isValidRedirectUri(requestObject, oAuth2Parameters)) {
            return false;
        }
        if (this.isParamPresent(requestObject, "request_uri") || this.isParamPresent(requestObject, "request")) {
            return false;
        }
        if (requestObject.isSigned()) {
            if (!this.isValidIssuer(requestObject, oAuth2Parameters)) {
                return false;
            }
            if (!this.isValidAudience(requestObject, oAuth2Parameters)) {
                return false;
            }
        }
        return true;
    }

    protected boolean isValidAudience(RequestObject requestObject, OAuth2Parameters oAuth2Parameters) throws RequestObjectException {
        String tokenEPUrl = this.getTokenEpURL(oAuth2Parameters.getTenantDomain());
        List audience = requestObject.getClaimsSet().getAudience();
        return this.validateAudience(tokenEPUrl, audience);
    }

    private boolean checkExpirationTime(RequestObject requestObject) throws RequestObjectException {
        Date expirationTime = requestObject.getClaimsSet().getExpirationTime();
        if (expirationTime != null) {
            long timeStampSkewMillis = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
            long expirationTimeInMillis = expirationTime.getTime();
            long currentTimeInMillis = System.currentTimeMillis();
            if (currentTimeInMillis + timeStampSkewMillis > expirationTimeInMillis) {
                String msg = "Request Object is expired., Expiration Time(ms) : " + expirationTimeInMillis + ", TimeStamp Skew : " + timeStampSkewMillis + ", Current Time : " + currentTimeInMillis + ". Token Rejected.";
                this.logAndReturnFalse(msg);
                throw new RequestObjectException("invalid_request", "Request Object is Expired.");
            }
        }
        return true;
    }

    protected boolean validateClientIdAndResponseType(RequestObject requestObject, OAuth2Parameters oauthRequest) throws RequestObjectException {
        String clientIdInReqObj = requestObject.getClaimValue("client_id");
        String responseTypeInReqObj = requestObject.getClaimValue("response_type");
        String errorMsg = "Request Object and Authorization request contains unmatched ";
        if (!this.isValidParameter(oauthRequest.getClientId(), clientIdInReqObj)) {
            throw new RequestObjectException("invalid_request", "Request Object and Authorization request contains unmatched client_id");
        }
        if (!this.isValidParameter(oauthRequest.getResponseType(), responseTypeInReqObj)) {
            throw new RequestObjectException("invalid_request", "Request Object and Authorization request contains unmatched response_type");
        }
        return true;
    }

    protected boolean isValidParameter(String authParam, String requestObjParam) {
        return StringUtils.isEmpty((String)requestObjParam) || requestObjParam.equals(authParam);
    }

    protected String getTokenEpURL(String tenantDomain) throws RequestObjectException {
        String residentIdpAlias = "";
        try {
            IdentityProvider residentIdP = IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
            FederatedAuthenticatorConfig oidcFedAuthn = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])residentIdP.getFederatedAuthenticatorConfigs(), (String)"openidconnect");
            Property idPEntityIdProperty = IdentityApplicationManagementUtil.getProperty((Property[])oidcFedAuthn.getProperties(), (String)OIDC_IDP_ENTITY_ID);
            if (idPEntityIdProperty != null) {
                residentIdpAlias = idPEntityIdProperty.getValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found IdPEntityID: " + residentIdpAlias + " for tenantDomain: " + tenantDomain));
                }
            }
        }
        catch (IdentityProviderManagementException e) {
            log.error((Object)("Error while loading OAuth2TokenEPUrl of the resident IDP of tenant:" + tenantDomain), (Throwable)e);
            throw new RequestObjectException("server_error", "Server Error while validating audience of Request Object.");
        }
        if (StringUtils.isEmpty((String)residentIdpAlias) && StringUtils.isNotEmpty((String)(residentIdpAlias = IdentityUtil.getProperty((String)OIDC_ID_TOKEN_ISSUER_ID))) && log.isDebugEnabled()) {
            log.debug((Object)("'IdPEntityID' property was empty for tenantDomain: " + tenantDomain + ". Using OIDC IDToken Issuer value: " + residentIdpAlias + " as alias to identify Resident IDP."));
        }
        return residentIdpAlias;
    }

    protected boolean isValidIssuer(RequestObject requestObject, OAuth2Parameters oAuth2Parameters) {
        String issuer = requestObject.getClaimsSet().getIssuer();
        return StringUtils.isNotEmpty((String)issuer) && issuer.equals(oAuth2Parameters.getClientId());
    }

    private boolean isParamPresent(RequestObject requestObject, String claim) {
        return StringUtils.isNotEmpty((String)requestObject.getClaimValue(claim));
    }

    protected boolean validateAudience(String currentAudience, List<String> audience) {
        for (String aud : audience) {
            if (!StringUtils.equals((String)currentAudience, (String)aud)) continue;
            return true;
        }
        return this.logAndReturnFalse("None of the audience values matched the tokenEndpoint Alias: " + currentAudience);
    }

    @Deprecated
    protected Certificate getCertificateForAlias(String tenantDomain, String alias) throws RequestObjectException {
        return this.getX509CertOfOAuthApp(alias, tenantDomain);
    }

    protected Certificate getX509CertOfOAuthApp(String clientId, String tenantDomain) throws RequestObjectException {
        try {
            return OAuth2Util.getX509CertOfOAuthApp(clientId, tenantDomain);
        }
        catch (IdentityOAuth2Exception e) {
            String errorMsg = "Error retrieving application certificate of OAuth app with client_id: " + clientId + " , tenantDomain: " + tenantDomain;
            if (StringUtils.isNotBlank((String)e.getMessage())) {
                errorMsg = e.getMessage();
            }
            throw new RequestObjectException(errorMsg, (Throwable)((Object)e));
        }
    }

    protected boolean isSignatureVerified(SignedJWT signedJWT, Certificate x509Certificate) {
        PublicKey publicKey;
        JWSHeader header = signedJWT.getHeader();
        if (x509Certificate == null) {
            return this.logAndReturnFalse("Unable to locate certificate for JWT " + header.toString());
        }
        String alg = signedJWT.getHeader().getAlgorithm().getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Signature Algorithm found in the JWT Header: " + alg));
        }
        if (alg.indexOf("RS") == 0 || alg.indexOf("PS") == 0) {
            publicKey = x509Certificate.getPublicKey();
            if (!(publicKey instanceof RSAPublicKey)) {
                return this.logAndReturnFalse("Public key is not an RSA public key.");
            }
        } else {
            return this.logAndReturnFalse("Signature Algorithm not supported yet : " + alg);
        }
        RSASSAVerifier verifier = new RSASSAVerifier((RSAPublicKey)publicKey);
        try {
            return signedJWT.verify((JWSVerifier)verifier);
        }
        catch (JOSEException e) {
            return this.logAndReturnFalse("Unable to verify the signature of the request object: " + signedJWT.serialize());
        }
    }

    private boolean logAndReturnFalse(String errorMessage) {
        if (log.isDebugEnabled()) {
            log.debug((Object)errorMessage);
        }
        return false;
    }

    protected boolean isValidRedirectUri(RequestObject requestObject, OAuth2Parameters oAuth2Parameters) {
        String redirectUriInReqObj = requestObject.getClaimValue("redirect_uri");
        return StringUtils.isBlank((String)redirectUriInReqObj) || StringUtils.equals((String)redirectUriInReqObj, (String)oAuth2Parameters.getRedirectURI());
    }
}

