/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.openidconnect;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.RequestObjectException;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.openidconnect.model.RequestedClaim;

public class RequestObjectService {
    private static final Log log = LogFactory.getLog(RequestObjectService.class);

    public void addRequestObject(String consumerKey, String sessionDataKey, List<List<RequestedClaim>> claims) throws RequestObjectException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking the RequestObjectPersistenceFactory to persist the request object claims against the sessionDataKey:" + sessionDataKey));
        }
        try {
            OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().insertRequestObjectData(consumerKey, sessionDataKey, claims);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)("Error while persisting the Request Object against sessionDataKey: " + sessionDataKey), (Throwable)((Object)e));
            throw new RequestObjectException("server_error", "Error while processing the Request Object");
        }
    }

    private List<RequestedClaim> getRequestedClaimsbySessionDataKey(String sessionDataKey, boolean isUserInfo) throws RequestObjectException {
        List<RequestedClaim> essentialClaims;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking the RequestObjectPersistenceFactory to retrieve essential claims list by using session data key:" + sessionDataKey + ", isUserInfo: " + isUserInfo));
        }
        try {
            essentialClaims = OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().getRequestedClaimsbySessionDataKey(sessionDataKey, isUserInfo);
        }
        catch (IdentityOAuth2Exception e) {
            throw new RequestObjectException(e.getMessage());
        }
        return essentialClaims;
    }

    private List<RequestedClaim> getRequestedClaims(String token, boolean isUserInfo) throws RequestObjectException {
        List<RequestedClaim> essentialClaims;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invoking the RequestObjectPersistenceFactory to retrieve essential claims list.");
        }
        try {
            essentialClaims = OAuthTokenPersistenceFactory.getInstance().getRequestObjectDAO().getRequestedClaims(token, isUserInfo);
        }
        catch (IdentityOAuth2Exception e) {
            throw new RequestObjectException(e.getMessage());
        }
        return essentialClaims;
    }

    public List<RequestedClaim> getRequestedClaimsForSessionDataKey(String sessionDataKey, boolean isUserInfo) throws RequestObjectException {
        return this.getRequestedClaimsbySessionDataKey(sessionDataKey, isUserInfo);
    }

    public List<RequestedClaim> getRequestedClaimsForIDToken(String token) throws RequestObjectException {
        return this.getRequestedClaims(token, false);
    }

    public List<RequestedClaim> getRequestedClaimsForUserInfo(String token) throws RequestObjectException {
        return this.getRequestedClaims(token, true);
    }
}

